/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.w3c.dom.Node;

public class DoubleAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#double";
    private static URI identifierURI = URI.create("http://www.w3.org/2001/XMLSchema#double");
    private double value;

    public DoubleAttribute(double value) {
        super(identifierURI);
        this.value = value;
    }

    public static DoubleAttribute getInstance(Node root) throws NumberFormatException {
        return DoubleAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static DoubleAttribute getInstance(String value) {
        if (value.endsWith("INF")) {
            int infIndex = value.lastIndexOf("INF");
            value = value.substring(0, infIndex) + "Infinity";
        }
        return new DoubleAttribute(Double.parseDouble(value));
    }

    public Double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DoubleAttribute)) {
            return false;
        }
        DoubleAttribute other = (DoubleAttribute)o;
        if (Double.isNaN(this.value)) {
            return Double.isNaN(other.value);
        }
        return this.value == other.value;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public String encode() {
        return String.valueOf(this.value);
    }
}

