/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modcluster.config.impl.SessionDrainingStrategyEnum;
import org.wildfly.extension.mod_cluster.CustomLoadMetricDefinition;
import org.wildfly.extension.mod_cluster.DynamicLoadProviderDefinition;
import org.wildfly.extension.mod_cluster.LoadMetricDefinition;
import org.wildfly.extension.mod_cluster.ModClusterAddCustomMetric;
import org.wildfly.extension.mod_cluster.ModClusterAddMetric;
import org.wildfly.extension.mod_cluster.ModClusterConfigAdd;
import org.wildfly.extension.mod_cluster.ModClusterExtension;
import org.wildfly.extension.mod_cluster.ModClusterModel;
import org.wildfly.extension.mod_cluster.ModClusterRemoveCustomMetric;
import org.wildfly.extension.mod_cluster.ModClusterRemoveMetric;
import org.wildfly.extension.mod_cluster.ModClusterSSLResourceDefinition;
import org.wildfly.extension.mod_cluster.ProxyConfigurationWriteAttributeHandler;
import org.wildfly.extension.mod_cluster.ProxyListValidator;
import org.wildfly.extension.mod_cluster.SSLContextWriteAttributeHandler;
import org.wildfly.extension.mod_cluster.SessionDrainingStrategyChecker;
import org.wildfly.extension.mod_cluster.ZeroToNegativeOneParameterCorrector;

class ModClusterConfigResourceDefinition
extends SimpleResourceDefinition {
    static final String UNDERTOW_LISTENER_CAPABILITY_NAME = "org.wildfly.undertow.listener";
    private static final String MOD_CLUSTER_CAPABILITY_NAME = "org.wildfly.mod_cluster";
    private static final RuntimeCapability<Void> MOD_CLUSTER_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.mod_cluster", (boolean)false).build();
    static final PathElement PATH = PathElement.pathElement((String)"mod-cluster-config", (String)"configuration");
    static final SimpleAttributeDefinition ADVERTISE_SOCKET = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"advertise-socket", (ModelType)ModelType.STRING, (boolean)true).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF)).build();
    static final SimpleAttributeDefinition CONNECTOR = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connector", (ModelType)ModelType.STRING, (boolean)false).setCapabilityReference("org.wildfly.undertow.listener", "org.wildfly.mod_cluster", false)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SESSION_DRAINING_STRATEGY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"session-draining-strategy", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(SessionDrainingStrategyEnum.DEFAULT.name()))).setValidator((ParameterValidator)new EnumValidator(SessionDrainingStrategyEnum.class, true, true, (Enum[])new SessionDrainingStrategyEnum[]{SessionDrainingStrategyEnum.ALWAYS, SessionDrainingStrategyEnum.DEFAULT, SessionDrainingStrategyEnum.NEVER}))).setRestartAllServices()).build();
    static final StringListAttributeDefinition PROXIES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("proxies").setAllowExpression(false)).setRequired(false)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PROXY_LIST = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"proxy-list", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setRestartAllServices()).setValidator((ParameterValidator)new ProxyListValidator())).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF)).setDeprecated(ModClusterModel.VERSION_2_0_0.getVersion())).addAlternatives(new String[]{PROXIES.getName()})).build();
    static final SimpleAttributeDefinition PROXY_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"proxy-url", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode("/"))).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_PROXIES_DEF)).build();
    static final SimpleAttributeDefinition ADVERTISE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"advertise", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition ADVERTISE_SECURITY_KEY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"advertise-security-key", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)ModClusterExtension.MOD_CLUSTER_SECURITY_DEF)).build();
    static final SimpleAttributeDefinition STATUS_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"status-interval", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition EXCLUDED_CONTEXTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"excluded-contexts", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition AUTO_ENABLE_CONTEXTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"auto-enable-contexts", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition STOP_CONTEXT_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"stop-context-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SOCKET_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"socket-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(20))).setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(1, true, true))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SSL_CONTEXT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("ssl-context", ModelType.STRING, true).setCapabilityReference(CommonUnaryRequirement.SSL_CONTEXT.getName(), "org.wildfly.mod_cluster", false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SSL_REF})).build();
    static final SimpleAttributeDefinition STICKY_SESSION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"sticky-session", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(true))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition STICKY_SESSION_REMOVE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"sticky-session-remove", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition STICKY_SESSION_FORCE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"sticky-session-force", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition WORKER_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"worker-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true))).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition MAX_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-attempts", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(1))).setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).setCorrector((newValue, currentValue) -> newValue.getType().equals((Object)ModelType.INT) && newValue.asInt() == -1 ? new ModelNode(1) : newValue)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition FLUSH_PACKETS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"flush-packets", (ModelType)ModelType.BOOLEAN, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setRestartAllServices()).build();
    static final SimpleAttributeDefinition FLUSH_WAIT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"flush-wait", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true))).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition PING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ping", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(10))).setMeasurementUnit(MeasurementUnit.SECONDS)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SMAX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"smax", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true))).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"ttl", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true))).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition NODE_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"node-timeout", (ModelType)ModelType.INT, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode(-1))).setMeasurementUnit(MeasurementUnit.SECONDS)).setValidator((ParameterValidator)new IntRangeValidator(-1, true, true))).setCorrector((ParameterCorrector)ZeroToNegativeOneParameterCorrector.INSTANCE)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition BALANCER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"balancer", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition LOAD_BALANCING_GROUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"load-balancing-group", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SIMPLE_LOAD_PROVIDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"simple-load-provider", (ModelType)ModelType.INT, (boolean)true).setRestartAllServices()).setXmlName("factor")).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{ADVERTISE_SOCKET, PROXY_LIST, PROXIES, PROXY_URL, BALANCER, ADVERTISE, ADVERTISE_SECURITY_KEY, EXCLUDED_CONTEXTS, AUTO_ENABLE_CONTEXTS, STOP_CONTEXT_TIMEOUT, SOCKET_TIMEOUT, STICKY_SESSION, STICKY_SESSION_REMOVE, STICKY_SESSION_FORCE, WORKER_TIMEOUT, MAX_ATTEMPTS, FLUSH_PACKETS, FLUSH_WAIT, PING, SMAX, TTL, NODE_TIMEOUT, LOAD_BALANCING_GROUP, CONNECTOR, SESSION_DRAINING_STRATEGY, STATUS_INTERVAL, SSL_CONTEXT};
    public static final Map<String, AttributeDefinition> ATTRIBUTES_BY_NAME;

    public static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(PATH);
        if (ModClusterModel.VERSION_4_1_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{SSL_CONTEXT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{SSL_CONTEXT})).end();
        }
        if (ModClusterModel.VERSION_4_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

                protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    if (!attributeValue.isDefined()) {
                        attributeValue.set(" ");
                    }
                }
            }, new AttributeDefinition[]{EXCLUDED_CONTEXTS})).end();
        }
        if (ModClusterModel.VERSION_3_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{STATUS_INTERVAL.getDefaultValue()}), new AttributeDefinition[]{STATUS_INTERVAL})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleAcceptAttributeChecker(STATUS_INTERVAL.getDefaultValue()), new AttributeDefinition[]{STATUS_INTERVAL})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{PROXIES})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{PROXIES})).end();
        }
        if (ModClusterModel.VERSION_1_5_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck((RejectAttributeChecker)SessionDrainingStrategyChecker.INSTANCE, new AttributeDefinition[]{SESSION_DRAINING_STRATEGY})).setDiscard((DiscardAttributeChecker)SessionDrainingStrategyChecker.INSTANCE, new AttributeDefinition[]{SESSION_DRAINING_STRATEGY})).end();
        }
        DynamicLoadProviderDefinition.buildTransformation(version, builder);
        ModClusterSSLResourceDefinition.buildTransformation(version, builder);
    }

    public ModClusterConfigResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, (ResourceDescriptionResolver)ModClusterExtension.getResourceDescriptionResolver("configuration")).setAddHandler((OperationStepHandler)ModClusterConfigAdd.INSTANCE).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler()).setCapabilities(new RuntimeCapability[]{MOD_CLUSTER_CAPABILITY}));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler defaultHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (attr.equals(PROXY_LIST) || attr.equals(PROXIES)) {
                resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new ProxyConfigurationWriteAttributeHandler(attr));
                continue;
            }
            if (attr.equals(SSL_CONTEXT)) {
                resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new SSLContextWriteAttributeHandler(attr));
                continue;
            }
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)defaultHandler);
        }
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SIMPLE_LOAD_PROVIDER, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{SIMPLE_LOAD_PROVIDER}));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ResourceDescriptionResolver rootResolver = this.getResourceDescriptionResolver();
        SimpleOperationDefinition addMetricDef = new SimpleOperationDefinitionBuilder("add-metric", rootResolver).setParameters(LoadMetricDefinition.ATTRIBUTES).setRuntimeOnly().build();
        SimpleOperationDefinition addCustomDef = new SimpleOperationDefinitionBuilder("add-custom-metric", rootResolver).setParameters(CustomLoadMetricDefinition.ATTRIBUTES).setRuntimeOnly().build();
        SimpleOperationDefinition removeMetricDef = new SimpleOperationDefinitionBuilder("remove-metric", rootResolver).setParameters(new AttributeDefinition[]{LoadMetricDefinition.TYPE}).setRuntimeOnly().build();
        SimpleOperationDefinition removeCustomDef = new SimpleOperationDefinitionBuilder("remove-custom-metric", rootResolver).setParameters(new AttributeDefinition[]{CustomLoadMetricDefinition.CLASS}).setRuntimeOnly().build();
        resourceRegistration.registerOperationHandler((OperationDefinition)addMetricDef, (OperationStepHandler)ModClusterAddMetric.INSTANCE);
        resourceRegistration.registerOperationHandler((OperationDefinition)addCustomDef, (OperationStepHandler)ModClusterAddCustomMetric.INSTANCE);
        resourceRegistration.registerOperationHandler((OperationDefinition)removeMetricDef, (OperationStepHandler)ModClusterRemoveMetric.INSTANCE);
        resourceRegistration.registerOperationHandler((OperationDefinition)removeCustomDef, (OperationStepHandler)ModClusterRemoveCustomMetric.INSTANCE);
    }

    static {
        HashMap<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();
        for (AttributeDefinition attr : ATTRIBUTES) {
            attributes.put(attr.getName(), attr);
        }
        ATTRIBUTES_BY_NAME = Collections.unmodifiableMap(attributes);
    }
}

