/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.Optional;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.NonResolvingResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.io.IOExtension;
import org.wildfly.extension.io.WorkerResourceDefinition;
import org.xnio.XnioWorker;
import org.xnio.management.XnioServerMXBean;
import org.xnio.management.XnioWorkerMXBean;

public class WorkerServerDefinition
extends SimpleResourceDefinition {
    private static final SimpleAttributeDefinition CONNECTION_COUNT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-count", ModelType.INT).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition CONNECTION_LIMIT_HIGH_MARK = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-limit-high-water-mark", ModelType.INT).setStorageRuntime()).build();
    private static final SimpleAttributeDefinition CONNECTION_LIMIT_LOW_MARK = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-limit-low-water-mark", ModelType.INT).setStorageRuntime()).build();

    WorkerServerDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"server"), (ResourceDescriptionResolver)new NonResolvingResourceDescriptionResolver()).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerMetric((AttributeDefinition)CONNECTION_COUNT, (OperationStepHandler)new ServerMetricsHandler(){

            @Override
            ModelNode getMetricValue(XnioServerMXBean metrics) {
                return new ModelNode(metrics.getConnectionCount());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CONNECTION_LIMIT_HIGH_MARK, (OperationStepHandler)new ServerMetricsHandler(){

            @Override
            ModelNode getMetricValue(XnioServerMXBean metrics) {
                return new ModelNode(metrics.getConnectionLimitHighWater());
            }
        });
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)CONNECTION_LIMIT_LOW_MARK, (OperationStepHandler)new ServerMetricsHandler(){

            @Override
            ModelNode getMetricValue(XnioServerMXBean metrics) {
                return new ModelNode(metrics.getConnectionLimitLowWater());
            }
        });
    }

    private static abstract class ServerMetricsHandler
    implements OperationStepHandler {
        private ServerMetricsHandler() {
        }

        abstract ModelNode getMetricValue(XnioServerMXBean var1);

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            XnioWorker worker = WorkerResourceDefinition.getXnioWorker(context);
            if (worker == null || worker.getMXBean() == null) {
                context.getResult().set(IOExtension.NO_METRICS);
                return;
            }
            XnioWorkerMXBean metrics = worker.getMXBean();
            Optional<XnioServerMXBean> serverMetrics = metrics.getServerMXBeans().stream().filter(xnioServerMXBean -> xnioServerMXBean.getBindAddress().equals(context.getCurrentAddressValue())).findFirst();
            if (serverMetrics.isPresent()) {
                context.getResult().set(this.getMetricValue(serverMetrics.get()));
            } else {
                context.getResult().set(IOExtension.NO_METRICS);
            }
        }
    }
}

