/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleMapAttributeDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.MultistepUtil;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jacorb.TransformUtils;
import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.iiop.openjdk.ConfigValidator;

public class MigrateOperation
implements OperationStepHandler {
    public static final String MIGRATE = "migrate";
    public static final String DESCRIBE_MIGRATION = "describe-migration";
    public static final String MIGRATION_OPERATIONS = "migration-operations";
    public static final String MIGRATION_WARNINGS = "migration-warnings";
    public static final String MIGRATION_ERROR = "migration-error";
    private static final PathAddress JACORB_EXTENSION = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension", (String)"org.jboss.as.jacorb")});
    private static final List<String> TRANSFORMED_PROPERTIES = Arrays.asList("giop-minor-version", "transactions", "security", "support-ssl", "add-component-via-interceptor", "export-corbaloc");
    public static final StringListAttributeDefinition MIGRATION_WARNINGS_ATTR = ((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("migration-warnings").setAllowNull(true)).build();
    public static final SimpleMapAttributeDefinition MIGRATION_ERROR_ATTR = ((SimpleMapAttributeDefinition.Builder)new SimpleMapAttributeDefinition.Builder("migration-error", ModelType.OBJECT, true).setValueType(ModelType.OBJECT).setAllowNull(true)).build();
    private static final PathElement OPENJDK_EXTENSION_ELEMENT = PathElement.pathElement((String)"extension", (String)"org.wildfly.iiop-openjdk");
    private static final PathElement OPENJDK_SUBSYSTEM_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"iiop-openjdk");
    private static final PathElement JACORB_SUBSYSTEM_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"jacorb");
    private final boolean describe;

    static void registerOperation(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(MIGRATE, resourceDescriptionResolver).setRuntimeOnly().setReplyParameters(new AttributeDefinition[]{MIGRATION_WARNINGS_ATTR, MIGRATION_ERROR_ATTR}).build(), (OperationStepHandler)new MigrateOperation(false));
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(DESCRIBE_MIGRATION, resourceDescriptionResolver).setRuntimeOnly().setReplyParameters(new AttributeDefinition[]{MIGRATION_WARNINGS_ATTR, MIGRATION_ERROR_ATTR}).build(), (OperationStepHandler)new MigrateOperation(true));
    }

    private MigrateOperation(boolean describe) {
        this.describe = describe;
    }

    public void execute(final OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException("the iiop migration can be performed when the server is in admin-only mode");
        }
        final PathAddress subsystemsAddress = context.getCurrentAddress().getParent();
        if (context.readResourceFromRoot(subsystemsAddress).hasChild(OPENJDK_SUBSYSTEM_ELEMENT)) {
            throw new OperationFailedException("can not migrate: the new iiop-openjdk subsystem is already defined");
        }
        final LinkedHashMap<PathAddress, ModelNode> migrateOperations = new LinkedHashMap<PathAddress, ModelNode>();
        if (!context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS).hasChild(OPENJDK_EXTENSION_ELEMENT)) {
            this.addOpenjdkExtension(context, migrateOperations);
        }
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext operationContext, ModelNode modelNode) throws OperationFailedException {
                Resource jacorbResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
                ModelNode jacorbModel = Resource.Tools.readModel((Resource)jacorbResource).clone();
                final LinkedList<String> warnings = new LinkedList<String>();
                List<String> unsupportedProperties = TransformUtils.validateDeprecatedProperites(jacorbModel);
                if (!unsupportedProperties.isEmpty()) {
                    warnings.add(JacORBLogger.ROOT_LOGGER.cannotEmulatePropertiesWarning(unsupportedProperties));
                    for (String unsupportedProperty : unsupportedProperties) {
                        jacorbModel.get(unsupportedProperty).clear();
                    }
                }
                MigrateOperation.this.checkPropertiesWithExpression(jacorbModel, warnings);
                ModelNode openjdkModel = TransformUtils.transformModel(jacorbModel);
                ConfigValidator.validateConfig((OperationContext)context, (ModelNode)openjdkModel);
                PathAddress openjdkAddress = subsystemsAddress.append(new PathElement[]{OPENJDK_SUBSYSTEM_ELEMENT});
                MigrateOperation.this.addOpenjdkSubsystem(openjdkAddress, openjdkModel, migrateOperations);
                PathAddress jacorbAddress = subsystemsAddress.append(new PathElement[]{JACORB_SUBSYSTEM_ELEMENT});
                MigrateOperation.this.removeJacorbSubsystem(jacorbAddress, migrateOperations, context.getProcessType() == ProcessType.STANDALONE_SERVER);
                if (MigrateOperation.this.describe) {
                    Collection values = migrateOperations.values();
                    ModelNode result = new ModelNode();
                    result.get(MigrateOperation.MIGRATION_OPERATIONS).set(values);
                    ModelNode rw = new ModelNode().setEmptyList();
                    for (String warning : warnings) {
                        rw.add(warning);
                    }
                    result.get(MigrateOperation.MIGRATION_WARNINGS).set(rw);
                    context.getResult().set(result);
                } else {
                    final Map migrateOpResponses = MigrateOperation.this.migrateSubsystems(context, migrateOperations);
                    context.completeStep(new OperationContext.ResultHandler(){

                        public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                            ModelNode result = new ModelNode();
                            ModelNode rw = new ModelNode().setEmptyList();
                            for (String string : warnings) {
                                rw.add(string);
                            }
                            result.get(MigrateOperation.MIGRATION_WARNINGS).set(rw);
                            if (resultAction == OperationContext.ResultAction.ROLLBACK) {
                                for (Map.Entry entry : migrateOpResponses.entrySet()) {
                                    if (!((ModelNode)entry.getValue()).hasDefined("failure-description")) continue;
                                    ModelNode desc = new ModelNode();
                                    desc.get("operation").set((ModelNode)migrateOperations.get(entry.getKey()));
                                    desc.get("result").set((ModelNode)entry.getValue());
                                    result.get(MigrateOperation.MIGRATION_ERROR).set(desc);
                                    break;
                                }
                                context.getFailureDescription().set(new ModelNode(JacORBLogger.ROOT_LOGGER.migrationFailed()));
                            }
                            context.getResult().set(result);
                        }
                    });
                }
            }
        }, OperationContext.Stage.MODEL);
    }

    private void checkPropertiesWithExpression(ModelNode legacyModel, List<String> warnings) {
        LinkedList<String> transformedExpressionProperties = new LinkedList<String>();
        for (Property property : legacyModel.asPropertyList()) {
            if (property.getValue().getType() != ModelType.EXPRESSION || !TRANSFORMED_PROPERTIES.contains(property.getName())) continue;
            transformedExpressionProperties.add(property.getName());
        }
        if (!transformedExpressionProperties.isEmpty()) {
            warnings.add(JacORBLogger.ROOT_LOGGER.expressionMigrationWarning(((Object)transformedExpressionProperties).toString()));
        }
    }

    private void addOpenjdkExtension(OperationContext context, Map<PathAddress, ModelNode> migrateOperations) {
        PathAddress extensionAddress = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{OPENJDK_EXTENSION_ELEMENT});
        OperationEntry addEntry = context.getRootResourceRegistration().getOperationEntry(extensionAddress, "add");
        ModelNode addOperation = Util.createAddOperation((PathAddress)extensionAddress);
        if (this.describe) {
            migrateOperations.put(extensionAddress, addOperation);
        } else {
            context.addStep(context.getResult().get(extensionAddress.toString()), addOperation, addEntry.getOperationHandler(), OperationContext.Stage.MODEL);
        }
    }

    private void addOpenjdkSubsystem(PathAddress address, ModelNode model, Map<PathAddress, ModelNode> migrateOperations) {
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        for (Property property : model.asPropertyList()) {
            if (!property.getValue().isDefined()) continue;
            operation.get(property.getName()).set(property.getValue());
        }
        migrateOperations.put(address, operation);
    }

    private void removeJacorbSubsystem(PathAddress address, Map<PathAddress, ModelNode> migrateOperations, boolean standalone) {
        ModelNode removeLegacySubsystemOperation = Util.createRemoveOperation((PathAddress)address);
        migrateOperations.put(address, removeLegacySubsystemOperation);
        if (standalone) {
            removeLegacySubsystemOperation = Util.createRemoveOperation((PathAddress)JACORB_EXTENSION);
            migrateOperations.put(JACORB_EXTENSION, removeLegacySubsystemOperation);
        }
    }

    private Map<PathAddress, ModelNode> migrateSubsystems(OperationContext context, Map<PathAddress, ModelNode> migrationOperations) throws OperationFailedException {
        LinkedHashMap<PathAddress, ModelNode> result = new LinkedHashMap<PathAddress, ModelNode>();
        MultistepUtil.recordOperationSteps((OperationContext)context, migrationOperations, result);
        return result;
    }
}

