/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import org.jgroups.util.Range;
import org.jgroups.util.Util;

public class Seqno {
    final long low;
    byte flags = 0;
    public static final byte DUMMY = 1;
    public static final byte RECEIVED = 2;

    public Seqno(long low) {
        this.low = low;
    }

    public Seqno(long num, boolean dummy) {
        this.low = num;
        if (dummy) {
            this.flags = Util.setFlag(this.flags, (byte)1);
        }
    }

    public boolean isDummy() {
        return Util.isFlagSet(this.flags, (byte)1);
    }

    public long getLow() {
        return this.low;
    }

    public boolean contains(long num) {
        return this.low == num;
    }

    public boolean get(long num) {
        return this.low == num && this.received();
    }

    public void set(long num) {
        if (this.low == num) {
            this.flags = Util.setFlag(this.flags, (byte)2);
        }
    }

    public void clear(long num) {
        if (this.low == num) {
            this.flags = Util.clearFlags(this.flags, (byte)2);
        }
    }

    public int getNumberOfReceivedMessages() {
        return this.received() ? 1 : 0;
    }

    public int getNumberOfMissingMessages() {
        return this.received() ? 0 : 1;
    }

    public int size() {
        return 1;
    }

    public Collection<Range> getMessagesToRetransmit() {
        ArrayList<Range> retval = new ArrayList<Range>(1);
        if (!this.received()) {
            retval.add(new Range(this.low, this.low));
        }
        return retval;
    }

    public int hashCode() {
        return (int)this.low;
    }

    public boolean equals(Object obj) {
        return obj instanceof Seqno && this.low == ((Seqno)obj).low;
    }

    public String toString() {
        if (this.isDummy()) {
            return this.low + " (dummy)";
        }
        return Long.toString(this.low);
    }

    public String print() {
        if (this.isDummy()) {
            return Long.toString(this.low);
        }
        return Long.toString(this.low);
    }

    protected boolean received() {
        return Util.isFlagSet(this.flags, (byte)2);
    }
}

