/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class RaRemove
implements OperationStepHandler {
    static final RaRemove INSTANCE = new RaRemove();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String archiveOrModuleName;
        boolean isModule;
        ModelNode opAddr = operation.require("address");
        final String idName = PathAddress.pathAddress((ModelNode)opAddr).getLastElement().getValue();
        final ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel();
        if (!model.hasDefined(Constants.ARCHIVE.getName()) && !model.hasDefined(Constants.MODULE.getName())) {
            throw ConnectorLogger.ROOT_LOGGER.archiveOrModuleRequired();
        }
        if (model.get(Constants.ARCHIVE.getName()).isDefined()) {
            isModule = false;
            archiveOrModuleName = model.get(Constants.ARCHIVE.getName()).asString();
        } else {
            isModule = true;
            archiveOrModuleName = model.get(Constants.MODULE.getName()).asString();
        }
        ModelNode compensating = Util.getEmptyOperation((String)"add", (ModelNode)opAddr);
        if (model.hasDefined("resource-adapters")) {
            for (ModelNode raNode : model.get("resource-adapters").asList()) {
                ModelNode raCompensatingNode = raNode.clone();
                compensating.get("resource-adapters").add(raCompensatingNode);
            }
        }
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final boolean wasActive = RaOperationUtil.removeIfActive(context, archiveOrModuleName, idName);
                if (wasActive && !context.isResourceServiceRestartAllowed()) {
                    context.reloadRequired();
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                            context.revertReloadRequired();
                        }
                    });
                    return;
                }
                ServiceName raServiceName = ServiceName.of((ServiceName)ConnectorServices.RA_SERVICE, (String[])new String[]{idName});
                ServiceController serviceController = context.getServiceRegistry(false).getService(raServiceName);
                final ModifiableResourceAdapter resourceAdapter = serviceController != null ? (ModifiableResourceAdapter)((Object)serviceController.getValue()) : null;
                List serviceNameList = context.getServiceRegistry(false).getServiceNames();
                for (ServiceName name : serviceNameList) {
                    if (!raServiceName.isParentOf(name)) continue;
                    context.removeService(name);
                }
                if (model.get(Constants.MODULE.getName()).isDefined()) {
                    ServiceName deployerServiceName = ConnectorServices.RESOURCE_ADAPTER_DEPLOYER_SERVICE_PREFIX.append(new String[]{idName});
                    context.removeService(deployerServiceName);
                    ServiceName inactiveServiceName = ConnectorServices.INACTIVE_RESOURCE_ADAPTER_SERVICE.append(new String[]{idName});
                    context.removeService(inactiveServiceName);
                }
                context.removeService(raServiceName);
                context.completeStep(new OperationContext.RollbackHandler(){

                    public void handleRollback(OperationContext context, ModelNode operation) {
                        if (resourceAdapter != null) {
                            LinkedList newControllers = new LinkedList();
                            if (model.get(Constants.ARCHIVE.getName()).isDefined()) {
                                RaOperationUtil.installRaServices(context, idName, resourceAdapter, newControllers);
                            } else {
                                try {
                                    RaOperationUtil.installRaServicesAndDeployFromModule(context, idName, resourceAdapter, archiveOrModuleName, newControllers);
                                }
                                catch (OperationFailedException operationFailedException) {
                                    // empty catch block
                                }
                            }
                            try {
                                if (wasActive) {
                                    RaOperationUtil.activate(context, idName, archiveOrModuleName);
                                }
                            }
                            catch (OperationFailedException operationFailedException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }
}

