/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.LockAbstract;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.utils.Base64;

@Command(name="decode", description="Decode a journal's internal format into a new journal set of files")
public class DecodeJournal
extends LockAbstract {
    @Option(name={"--directory"}, description="The journal folder (default journal folder from broker.xml)")
    public String directory;
    @Option(name={"--prefix"}, description="The journal prefix (default activemq-data)")
    public String prefix = "activemq-data";
    @Option(name={"--suffix"}, description="The journal suffix (default amq)")
    public String suffix = "amq";
    @Option(name={"--file-size"}, description="The journal size (default 10485760)")
    public int size = 0xA00000;
    @Option(name={"--input"}, description="The input file name (default=exp.dmp)", required=true)
    public String input = "exp.dmp";

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        try {
            if (this.directory == null) {
                this.directory = this.getFileConfiguration().getJournalDirectory();
            }
            DecodeJournal.importJournal(this.directory, this.prefix, this.suffix, 2, this.size, this.input);
        }
        catch (Exception e) {
            this.treatError(e, "data", "decode");
        }
        return null;
    }

    public static void importJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, String fileInput) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(new File(fileInput));
        DecodeJournal.importJournal(directory, journalPrefix, journalSuffix, minFiles, fileSize, fileInputStream);
    }

    public static void importJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, InputStream stream) throws Exception {
        InputStreamReader reader = new InputStreamReader(stream);
        DecodeJournal.importJournal(directory, journalPrefix, journalSuffix, minFiles, fileSize, reader);
    }

    public static void importJournal(String directory, String journalPrefix, String journalSuffix, int minFiles, int fileSize, Reader reader) throws Exception {
        String line;
        NIOSequentialFileFactory nio;
        JournalImpl journal;
        File journalDir = new File(directory);
        if (!journalDir.exists() && !journalDir.mkdirs()) {
            System.err.println("Could not create directory " + directory);
        }
        if ((journal = new JournalImpl(fileSize, minFiles, minFiles, 0, 0, (SequentialFileFactory)(nio = new NIOSequentialFileFactory(new File(directory), null, 1)), journalPrefix, journalSuffix, 1)).orderFiles().size() != 0) {
            throw new IllegalStateException("Import needs to create a brand new journal");
        }
        journal.start();
        journal.loadInternalOnly();
        BufferedReader buffReader = new BufferedReader(reader);
        HashMap<Long, AtomicInteger> txCounters = new HashMap<Long, AtomicInteger>();
        long lineNumber = 0L;
        while ((line = buffReader.readLine()) != null) {
            ++lineNumber;
            String[] splitLine = line.split(",");
            if (splitLine[0].equals("#File")) {
                txCounters.clear();
                continue;
            }
            Properties lineProperties = DecodeJournal.parseLine(splitLine);
            String operation = null;
            try {
                AtomicInteger counter;
                RecordInfo info;
                operation = lineProperties.getProperty("operation");
                if (operation.equals("AddRecord")) {
                    RecordInfo info2 = DecodeJournal.parseRecord(lineProperties);
                    journal.appendAddRecord(info2.id, info2.userRecordType, info2.data, false);
                    continue;
                }
                if (operation.equals("AddRecordTX")) {
                    long txID = DecodeJournal.parseLong("txID", lineProperties);
                    AtomicInteger counter2 = DecodeJournal.getCounter(txID, txCounters);
                    counter2.incrementAndGet();
                    info = DecodeJournal.parseRecord(lineProperties);
                    journal.appendAddRecordTransactional(txID, info.id, info.userRecordType, info.data);
                    continue;
                }
                if (operation.equals("UpdateTX")) {
                    long txID = DecodeJournal.parseLong("txID", lineProperties);
                    AtomicInteger counter3 = DecodeJournal.getCounter(txID, txCounters);
                    counter3.incrementAndGet();
                    info = DecodeJournal.parseRecord(lineProperties);
                    journal.appendUpdateRecordTransactional(txID, info.id, info.userRecordType, info.data);
                    continue;
                }
                if (operation.equals("Update")) {
                    RecordInfo info3 = DecodeJournal.parseRecord(lineProperties);
                    journal.appendUpdateRecord(info3.id, info3.userRecordType, info3.data, false);
                    continue;
                }
                if (operation.equals("DeleteRecord")) {
                    long id = DecodeJournal.parseLong("id", lineProperties);
                    try {
                        journal.appendDeleteRecord(id, false);
                    }
                    catch (IllegalStateException counter3) {}
                    continue;
                }
                if (operation.equals("DeleteRecordTX")) {
                    long txID = DecodeJournal.parseLong("txID", lineProperties);
                    long id = DecodeJournal.parseLong("id", lineProperties);
                    AtomicInteger counter4 = DecodeJournal.getCounter(txID, txCounters);
                    counter4.incrementAndGet();
                    journal.appendDeleteRecordTransactional(txID, id);
                    continue;
                }
                if (operation.equals("Prepare")) {
                    long txID = DecodeJournal.parseLong("txID", lineProperties);
                    int numberOfRecords = DecodeJournal.parseInt("numberOfRecords", lineProperties);
                    counter = DecodeJournal.getCounter(txID, txCounters);
                    byte[] data = DecodeJournal.parseEncoding("extraData", lineProperties);
                    if (counter.get() == numberOfRecords) {
                        journal.appendPrepareRecord(txID, data, false);
                        continue;
                    }
                    System.err.println("Transaction " + txID + " at line " + lineNumber + " is incomplete. The prepare record expected " + numberOfRecords + " while the import only had " + counter);
                    continue;
                }
                if (operation.equals("Commit")) {
                    long txID = DecodeJournal.parseLong("txID", lineProperties);
                    int numberOfRecords = DecodeJournal.parseInt("numberOfRecords", lineProperties);
                    counter = DecodeJournal.getCounter(txID, txCounters);
                    if (counter.get() == numberOfRecords) {
                        journal.appendCommitRecord(txID, false);
                        continue;
                    }
                    System.err.println("Transaction " + txID + " at line " + lineNumber + " is incomplete. The commit record expected " + numberOfRecords + " while the import only had " + counter);
                    continue;
                }
                if (operation.equals("Rollback")) {
                    long txID = DecodeJournal.parseLong("txID", lineProperties);
                    journal.appendRollbackRecord(txID, false);
                    continue;
                }
                System.err.println("Invalid operation " + operation + " at line " + lineNumber);
            }
            catch (Exception ex) {
                System.err.println("Error at line " + lineNumber + ", operation=" + operation + " msg = " + ex.getMessage());
            }
        }
        journal.stop();
    }

    protected static AtomicInteger getCounter(Long txID, Map<Long, AtomicInteger> txCounters) {
        AtomicInteger counter = txCounters.get(txID);
        if (counter == null) {
            counter = new AtomicInteger(0);
            txCounters.put(txID, counter);
        }
        return counter;
    }

    protected static RecordInfo parseRecord(Properties properties) throws Exception {
        long id = DecodeJournal.parseLong("id", properties);
        byte userRecordType = DecodeJournal.parseByte("userRecordType", properties);
        boolean isUpdate = DecodeJournal.parseBoolean("isUpdate", properties);
        byte[] data = DecodeJournal.parseEncoding("data", properties);
        return new RecordInfo(id, userRecordType, data, isUpdate, 0);
    }

    private static byte[] parseEncoding(String name, Properties properties) throws Exception {
        String value = DecodeJournal.parseString(name, properties);
        return DecodeJournal.decode(value);
    }

    private static int parseInt(String name, Properties properties) throws Exception {
        String value = DecodeJournal.parseString(name, properties);
        return Integer.parseInt(value);
    }

    private static long parseLong(String name, Properties properties) throws Exception {
        String value = DecodeJournal.parseString(name, properties);
        return Long.parseLong(value);
    }

    private static boolean parseBoolean(String name, Properties properties) throws Exception {
        String value = DecodeJournal.parseString(name, properties);
        return Boolean.parseBoolean(value);
    }

    private static byte parseByte(String name, Properties properties) throws Exception {
        String value = DecodeJournal.parseString(name, properties);
        return Byte.parseByte(value);
    }

    private static String parseString(String name, Properties properties) throws Exception {
        String value = properties.getProperty(name);
        if (value == null) {
            throw new Exception("property " + name + " not found");
        }
        return value;
    }

    protected static Properties parseLine(String[] splitLine) {
        Properties properties = new Properties();
        for (String el : splitLine) {
            String[] tuple = el.split("@");
            if (tuple.length == 2) {
                properties.put(tuple[0], tuple[1]);
                continue;
            }
            properties.put(tuple[0], tuple[0]);
        }
        return properties;
    }

    private static byte[] decode(String data) {
        return Base64.decode((String)data, (int)24);
    }

    public void printUsage() {
        int i;
        for (i = 0; i < 10; ++i) {
            System.err.println();
        }
        System.err.println("This method will export the journal at low level record.");
        System.err.println();
        System.err.println();
        for (i = 0; i < 10; ++i) {
            System.err.println();
        }
    }
}

