/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.util.EnumSet;

public enum CallbackKind {
    PRINCIPAL,
    CREDENTIAL,
    CREDENTIAL_RESET,
    REALM,
    PEER_PRINCIPAL,
    PEER_CREDENTIAL,
    CHOICE,
    PARAMETERS,
    SERVER_TRUSTED_AUTHORITIES,
    GENERAL_OUTPUT,
    GENERAL_INPUT;

    private static final int fullSize;

    public static boolean isFull(EnumSet<CallbackKind> set) {
        return set != null && set.size() == fullSize;
    }

    public boolean in(CallbackKind v1) {
        return this == v1;
    }

    public boolean in(CallbackKind v1, CallbackKind v2) {
        return this == v1 || this == v2;
    }

    public boolean in(CallbackKind v1, CallbackKind v2, CallbackKind v3) {
        return this == v1 || this == v2 || this == v3;
    }

    public boolean in(CallbackKind ... values) {
        if (values != null) {
            for (CallbackKind value : values) {
                if (this != value) continue;
                return true;
            }
        }
        return false;
    }

    static {
        fullSize = CallbackKind.values().length;
    }
}

