/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.event.RealmEvent;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public interface SecurityRealm {
    public static final SecurityRealm EMPTY_REALM = new SecurityRealm(){

        @Override
        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            return RealmIdentity.NON_EXISTENT;
        }

        @Override
        public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
            return RealmIdentity.NON_EXISTENT;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("credentialType", credentialType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam("evidenceType", evidenceType);
            return SupportLevel.UNSUPPORTED;
        }
    };

    default public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        return RealmIdentity.NON_EXISTENT;
    }

    default public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
        Principal principal = evidence.getPrincipal();
        return principal == null ? RealmIdentity.NON_EXISTENT : this.getRealmIdentity(principal);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> var1, String var2) throws RealmUnavailableException;

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> var1, String var2) throws RealmUnavailableException;

    default public void handleRealmEvent(RealmEvent event) {
    }

    public static void safeHandleRealmEvent(SecurityRealm realm, RealmEvent event) {
        Assert.checkNotNullParam("realm", realm);
        Assert.checkNotNullParam("event", event);
        try {
            realm.handleRealmEvent(event);
        }
        catch (Throwable t) {
            ElytronMessages.log.eventHandlerFailed(t);
        }
    }
}

