/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClient;
import org.wildfly.security.sasl.util.SaslWrapper;

public final class PrivilegedSaslClient
extends AbstractDelegatingSaslClient
implements SaslWrapper {
    private final AccessControlContext accessControlContext;

    PrivilegedSaslClient(SaslClient delegate, AccessControlContext accessControlContext) {
        super(delegate);
        Assert.checkNotNullParam("delegate", delegate);
        Assert.checkNotNullParam("accessControlContext", accessControlContext);
        this.accessControlContext = accessControlContext;
    }

    public PrivilegedSaslClient(SaslClient delegate) {
        this(delegate, AccessController.getContext());
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        try {
            return WildFlySecurityManager.doPrivilegedWithParameter(challenge, this.delegate::evaluateChallenge, this.accessControlContext);
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | SaslException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        try {
            return AccessController.doPrivileged(() -> this.delegate.unwrap(incoming, offset, len), this.accessControlContext);
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | SaslException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        try {
            return AccessController.doPrivileged(() -> this.delegate.wrap(outgoing, offset, len), this.accessControlContext);
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | SaslException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }
}

