/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.Nonbinding;
import org.jboss.weld.probe.SecurityActions;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.reflection.GenericArrayTypeImpl;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.WildcardTypeImpl;

@Vetoed
final class Parsers {
    private Parsers() {
    }

    static Type parseType(String value, ResourceLoader resourceLoader) {
        if ((value = value.trim()).equals("?")) {
            return WildcardTypeImpl.defaultInstance();
        }
        if (value.startsWith("? extends")) {
            Type upperBound = Parsers.parseType(value.substring("? extends".length(), value.length()), resourceLoader);
            if (upperBound == null) {
                return null;
            }
            return WildcardTypeImpl.withUpperBound((Type)upperBound);
        }
        if (value.startsWith("? super")) {
            Type lowerBound = Parsers.parseType(value.substring("? super".length(), value.length()), resourceLoader);
            if (lowerBound == null) {
                return null;
            }
            return WildcardTypeImpl.withLowerBound((Type)lowerBound);
        }
        if (value.contains("[]")) {
            Type componentType = Parsers.parseType(value.substring(0, value.indexOf("[]")), resourceLoader);
            if (componentType == null) {
                return null;
            }
            return new GenericArrayTypeImpl(componentType);
        }
        int chevLeft = value.indexOf("<");
        String rawValue = chevLeft < 0 ? value : value.substring(0, chevLeft);
        Class<?> rawRequiredType = Parsers.tryLoadClass(rawValue, resourceLoader);
        if (rawRequiredType == null) {
            return null;
        }
        if (rawRequiredType.getTypeParameters().length == 0) {
            return rawRequiredType;
        }
        int chevRight = value.lastIndexOf(">");
        if (chevRight < 0) {
            return null;
        }
        List<String> parts = Parsers.split(value.substring(chevLeft + 1, chevRight), ',', "<".charAt(0), ">".charAt(0));
        Type[] typeParameters = new Type[parts.size()];
        for (int i = 0; i < typeParameters.length; ++i) {
            Type typeParam = Parsers.parseType(parts.get(i), resourceLoader);
            if (typeParam == null) {
                return null;
            }
            typeParameters[i] = typeParam;
        }
        return new ParameterizedTypeImpl(rawRequiredType, typeParameters);
    }

    static List<QualifierInstance> parseQualifiers(String qualifiers, ResourceLoader resourceLoader, BeanManager beanManager) {
        ArrayList<QualifierInstance> qualifierInstances = new ArrayList<QualifierInstance>();
        for (String qualifier : Parsers.splitQualifiers(qualifiers)) {
            qualifierInstances.add(Parsers.createQualifierInstance(qualifier, resourceLoader, beanManager));
        }
        return qualifierInstances;
    }

    static QualifierInstance createQualifierInstance(String qualifier, ResourceLoader resourceLoader, BeanManager beanManager) {
        String qualifierType = qualifier.contains("(") ? qualifier.substring(0, qualifier.indexOf("(")) : qualifier;
        Class<?> qualifierClass = Parsers.tryLoadClass(qualifierType, resourceLoader);
        if (qualifierClass != null) {
            Class<?> qualifierAnnotationClass;
            try {
                qualifierAnnotationClass = qualifierClass;
            }
            catch (Exception e) {
                return null;
            }
            if (beanManager.isQualifier(qualifierAnnotationClass)) {
                Map<String, Object> values;
                Method[] qualifierMembers = SecurityActions.getDeclaredMethods(qualifierAnnotationClass);
                if (qualifierMembers.length == 0) {
                    values = Collections.emptyMap();
                } else {
                    Map<String, String> memberValues = Parsers.parseMemberValues(qualifier);
                    values = new HashMap();
                    for (Method method : qualifierMembers) {
                        if (method.isAnnotationPresent(Nonbinding.class)) continue;
                        String value = memberValues.get(method.getName());
                        if (value == null) {
                            Object defaultValue = method.getDefaultValue();
                            if (defaultValue == null) {
                                return null;
                            }
                            values.put(method.getName(), defaultValue);
                            continue;
                        }
                        Object extracted = Parsers.extractValue(method, value);
                        if (extracted == null) {
                            return null;
                        }
                        values.put(method.getName(), extracted);
                    }
                }
                return new QualifierInstance(qualifierAnnotationClass, Collections.unmodifiableMap(values));
            }
        }
        return null;
    }

    private static List<String> splitQualifiers(String value) {
        if (value == null || value.isEmpty()) {
            Collections.emptyList();
        }
        return Parsers.split(value.replace("@", ""), ",".charAt(0), "(".charAt(0), ")".charAt(0));
    }

    private static Map<String, String> parseMemberValues(String qualifier) {
        if (qualifier.contains("(") && qualifier.contains(")")) {
            HashMap<String, String> values = new HashMap<String, String>();
            List<String> parts = Parsers.split(qualifier.substring(qualifier.indexOf("(") + 1, qualifier.lastIndexOf(")")), ",".charAt(0), "\"".charAt(0), "\"".charAt(0));
            for (String part : parts) {
                values.put(part.substring(0, part.indexOf("=")), part.substring(part.indexOf("=") + 1, part.length()));
            }
            return values;
        }
        return Collections.emptyMap();
    }

    private static List<String> split(String value, char on, char ignoreStart, char ignoreEnd) {
        ArrayList<String> values = new ArrayList<String>();
        boolean ignore = false;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == on) {
                if (!ignore) {
                    if (buffer.length() <= 0) continue;
                    values.add(buffer.toString());
                    buffer = new StringBuilder();
                    continue;
                }
                buffer.append(value.charAt(i));
                continue;
            }
            if (value.charAt(i) == ignoreStart) {
                ignore = true;
            } else if (value.charAt(i) == ignoreEnd) {
                ignore = false;
            }
            buffer.append(value.charAt(i));
        }
        if (buffer.length() > 0) {
            values.add(buffer.toString());
        }
        return values;
    }

    private static Object extractValue(Method member, String value) {
        Class<?> type = member.getReturnType();
        if (type.equals(String.class) && value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        if (type.isPrimitive()) {
            if (Boolean.TYPE.equals(type)) {
                return Boolean.valueOf(value);
            }
            if (Character.TYPE.equals(type)) {
                return Character.valueOf(value.charAt(0));
            }
            if (Byte.TYPE.equals(type)) {
                return Byte.valueOf(value);
            }
            if (Short.TYPE.equals(type)) {
                return Short.valueOf(value);
            }
            if (Integer.TYPE.equals(type)) {
                return Integer.valueOf(value);
            }
            if (Long.TYPE.equals(type)) {
                return Long.valueOf(value);
            }
            if (Float.TYPE.equals(type)) {
                return Float.valueOf(value);
            }
            if (Double.TYPE.equals(type)) {
                return Double.valueOf(value);
            }
        } else if (type.equals(Class.class)) {
            return Reflections.loadClass((String)value, (ResourceLoader)WeldClassLoaderResourceLoader.INSTANCE);
        }
        return null;
    }

    private static Class<?> tryLoadClass(String value, ResourceLoader resourceLoader) {
        Class result = null;
        if (resourceLoader != null) {
            result = Reflections.loadClass((String)value, (ResourceLoader)resourceLoader);
        }
        return result == null ? Reflections.loadClass((String)value, (ResourceLoader)WeldClassLoaderResourceLoader.INSTANCE) : result;
    }
}

