/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.protocol.remote;

import java.net.URI;
import org.jboss.ejb.client.AbstractEJBMetaData;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.EJBMetaDataImpl;
import org.jboss.ejb.client.NodeAffinity;
import org.jboss.ejb.client.URIAffinity;
import org.jboss.marshalling.ObjectResolver;
import org.wildfly.common.rpc.RemoteExceptionCause;

final class ProtocolV1ObjectResolver
implements ObjectResolver {
    private static final boolean DISABLE_V1_AFFINITY_REWRITE = Boolean.getBoolean("org.jboss.ejb.client.disable-v1-affinity-rewrite");
    private final Affinity peerURIAffinity;
    private final NodeAffinity nodeAffinity;

    ProtocolV1ObjectResolver(String nodeName, URI peerURI) {
        this.nodeAffinity = new NodeAffinity(nodeName);
        this.peerURIAffinity = Affinity.forUri(peerURI);
    }

    public Object readResolve(Object replacement) {
        if (replacement instanceof EJBMetaDataImpl) {
            return ((EJBMetaDataImpl)replacement).toAbstractEJBMetaData();
        }
        if (replacement instanceof NodeAffinity && replacement.equals(this.nodeAffinity)) {
            return this.peerURIAffinity;
        }
        if (replacement == Affinity.NONE && !DISABLE_V1_AFFINITY_REWRITE) {
            return this.peerURIAffinity;
        }
        return replacement;
    }

    public Object writeReplace(Object original) {
        if (original instanceof URIAffinity) {
            return Affinity.NONE;
        }
        if (original == Affinity.LOCAL) {
            return this.nodeAffinity;
        }
        if (original instanceof AbstractEJBMetaData) {
            return new EJBMetaDataImpl((AbstractEJBMetaData)original);
        }
        if (original instanceof RemoteExceptionCause) {
            return ((RemoteExceptionCause)original).toPlainThrowable();
        }
        return original;
    }
}

