/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.wildfly.security.auth.server.SecurityIdentity;

public final class SecurityIdentityInterceptor
implements Interceptor {
    private static final SecurityIdentityInterceptor INSTANCE = new SecurityIdentityInterceptor();
    private static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory(INSTANCE);

    private SecurityIdentityInterceptor() {
    }

    public static SecurityIdentityInterceptor getInstance() {
        return INSTANCE;
    }

    public static InterceptorFactory getFactory() {
        return FACTORY;
    }

    @Override
    public Object processInvocation(InterceptorContext context) throws Exception {
        SecurityIdentity identity = context.getPrivateData(SecurityIdentity.class);
        if (identity != null) {
            try {
                return identity.runAs((PrivilegedExceptionAction)context);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return context.proceed();
    }
}

