/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Consumer;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class CacheConfigurationBuilder
implements ResourceServiceBuilder<Configuration>,
Consumer<org.infinispan.configuration.cache.ConfigurationBuilder> {
    private final InjectedValue<EvictionConfiguration> eviction = new InjectedValue();
    private final InjectedValue<ExpirationConfiguration> expiration = new InjectedValue();
    private final InjectedValue<LockingConfiguration> locking = new InjectedValue();
    private final InjectedValue<PersistenceConfiguration> persistence = new InjectedValue();
    private final InjectedValue<TransactionConfiguration> transaction = new InjectedValue();
    private final InjectedValue<Module> module = new InjectedValue();
    private final PathAddress address;
    private final String containerName;
    private final String cacheName;
    private volatile Builder<Configuration> builder;
    private volatile ValueDependency<GlobalConfiguration> global;
    private volatile JMXStatisticsConfiguration statistics;

    CacheConfigurationBuilder(PathAddress address) {
        this.address = address;
        this.containerName = address.getParent().getLastElement().getValue();
        this.cacheName = address.getLastElement().getValue();
    }

    public ServiceName getServiceName() {
        return CacheResourceDefinition.Capability.CONFIGURATION.getServiceName(this.address);
    }

    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        ServiceBuilder builder = this.builder.build(target).addDependency(CacheComponent.EVICTION.getServiceName(this.address), EvictionConfiguration.class, this.eviction).addDependency(CacheComponent.EXPIRATION.getServiceName(this.address), ExpirationConfiguration.class, this.expiration).addDependency(CacheComponent.LOCKING.getServiceName(this.address), LockingConfiguration.class, this.locking).addDependency(CacheComponent.PERSISTENCE.getServiceName(this.address), PersistenceConfiguration.class, this.persistence).addDependency(CacheComponent.TRANSACTION.getServiceName(this.address), TransactionConfiguration.class, this.transaction).addDependency(CacheComponent.MODULE.getServiceName(this.address), Module.class, this.module).setInitialMode(ServiceController.Mode.PASSIVE);
        return this.global.register(builder);
    }

    public Builder<Configuration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        boolean enabled = CacheResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        this.statistics = new org.infinispan.configuration.cache.ConfigurationBuilder().jmxStatistics().enabled(enabled).available(enabled).create();
        this.global = new InjectedValueDependency(InfinispanRequirement.CONFIGURATION.getServiceName(context, this.containerName), GlobalConfiguration.class);
        this.builder = new ConfigurationBuilder(CacheResourceDefinition.Capability.CONFIGURATION.getServiceName(context.getCurrentAddress()), this.containerName, this.cacheName, this.andThen(builder -> {
            CacheMode mode = builder.clustering().cacheMode();
            if (mode.isSynchronous() && ((TransactionConfiguration)this.transaction.getValue()).lockingMode() == LockingMode.OPTIMISTIC && ((LockingConfiguration)this.locking.getValue()).isolationLevel() == IsolationLevel.REPEATABLE_READ) {
                builder.locking().writeSkewCheck(true);
                builder.versioning().enable().scheme(VersioningScheme.SIMPLE);
            }
            GroupsConfigurationBuilder groupsBuilder = builder.clustering().hash().groups().enabled();
            ((Module)this.module.getValue()).loadService(Grouper.class).forEach(grouper -> groupsBuilder.addGrouper(grouper));
        })).configure(context);
        return this;
    }

    @Override
    public void accept(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        builder.eviction().read((EvictionConfiguration)this.eviction.getValue());
        builder.expiration().read((ExpirationConfiguration)this.expiration.getValue());
        builder.locking().read((LockingConfiguration)this.locking.getValue());
        builder.persistence().read((PersistenceConfiguration)this.persistence.getValue());
        builder.transaction().read((TransactionConfiguration)this.transaction.getValue());
        builder.jmxStatistics().read(this.statistics);
    }
}

