/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.HashConfigurationBuilder;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.distribution.ch.impl.TopologyAwareConsistentHashFactory;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.ConsistentHashStrategy;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class DistributedCacheBuilder
extends SharedStateCacheBuilder {
    private final String containerName;
    private volatile ValueDependency<GlobalConfiguration> global;
    private volatile HashConfiguration hash;
    private volatile L1Configuration l1;
    private volatile ConsistentHashStrategy consistentHashStrategy;

    DistributedCacheBuilder(PathAddress address) {
        super(address, CacheMode.DIST_SYNC);
        this.containerName = address.getParent().getLastElement().getValue();
    }

    @Override
    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return this.global.register(super.build(target));
    }

    @Override
    public Builder<Configuration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.consistentHashStrategy = (ConsistentHashStrategy)ModelNodes.asEnum((ModelNode)DistributedCacheResourceDefinition.Attribute.CONSISTENT_HASH_STRATEGY.resolveModelAttribute((ExpressionResolver)context, model), ConsistentHashStrategy.class);
        ClusteringConfigurationBuilder builder = new ConfigurationBuilder().clustering();
        this.hash = builder.hash().capacityFactor((float)DistributedCacheResourceDefinition.Attribute.CAPACITY_FACTOR.resolveModelAttribute((ExpressionResolver)context, model).asInt()).numOwners(DistributedCacheResourceDefinition.Attribute.OWNERS.resolveModelAttribute((ExpressionResolver)context, model).asInt()).numSegments(DistributedCacheResourceDefinition.Attribute.SEGMENTS.resolveModelAttribute((ExpressionResolver)context, model).asInt()).create();
        long l1Lifespan = DistributedCacheResourceDefinition.Attribute.L1_LIFESPAN.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.l1 = builder.l1().enabled(l1Lifespan > 0L).lifespan(l1Lifespan).create();
        this.global = new InjectedValueDependency(InfinispanRequirement.CONFIGURATION.getServiceName(context, this.containerName), GlobalConfiguration.class);
        return super.configure(context, model);
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        super.accept(builder);
        HashConfigurationBuilder hash = builder.clustering().l1().read(this.l1).hash().read(this.hash);
        if (this.consistentHashStrategy == ConsistentHashStrategy.INTRA_CACHE) {
            hash.consistentHashFactory((ConsistentHashFactory)(((GlobalConfiguration)this.global.getValue()).transport().hasTopologyInfo() ? new TopologyAwareConsistentHashFactory() : new DefaultConsistentHashFactory()));
        }
    }
}

