/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.service.Builder;

public class FileStoreBuilder
extends StoreBuilder<SingleFileStoreConfiguration, SingleFileStoreConfigurationBuilder> {
    private final InjectedValue<PathManager> pathManager = new InjectedValue();
    private final String containerName;
    private volatile String relativePath;
    private volatile String relativeTo;

    FileStoreBuilder(PathAddress cacheAddress) {
        super(cacheAddress, (context, model) -> new ConfigurationBuilder().persistence().addSingleFileStore());
        this.containerName = cacheAddress.getParent().getLastElement().getValue();
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, this.pathManager);
    }

    @Override
    public Builder<PersistenceConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.relativePath = ModelNodes.optionalString((ModelNode)FileStoreResourceDefinition.Attribute.RELATIVE_PATH.resolveModelAttribute((ExpressionResolver)context, model)).orElse("infinispan" + File.separatorChar + this.containerName);
        this.relativeTo = FileStoreResourceDefinition.Attribute.RELATIVE_TO.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return super.configure(context, model);
    }

    @Override
    public void accept(SingleFileStoreConfigurationBuilder builder) {
        builder.location(((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(this.relativePath, this.relativeTo));
    }
}

