/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.sql.DataSource;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.DataSourceConnectionFactoryConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public abstract class JDBCStoreBuilder<C extends AbstractJdbcStoreConfiguration, B extends AbstractJdbcStoreConfigurationBuilder<C, B>>
extends StoreBuilder<C, B> {
    private volatile ValueDependency<DataSource> dataSourceDepencency;

    JDBCStoreBuilder(Class<B> builderClass, PathAddress cacheAddress) {
        super(cacheAddress, (context, model) -> ((AbstractJdbcStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(builderClass)).dialect((DatabaseType)ModelNodes.optionalEnum((ModelNode)JDBCStoreResourceDefinition.Attribute.DIALECT.resolveModelAttribute((ExpressionResolver)context, (ModelNode)model), DatabaseType.class).orElse(null)));
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return this.dataSourceDepencency.register(super.build(target));
    }

    @Override
    public Builder<PersistenceConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String dataSource = JDBCStoreResourceDefinition.Attribute.DATA_SOURCE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.dataSourceDepencency = new InjectedValueDependency(CommonUnaryRequirement.DATA_SOURCE.getServiceName(context, dataSource), DataSource.class);
        return super.configure(context, model);
    }

    @Override
    public void accept(B builder) {
        ((DataSourceConnectionFactoryConfigurationBuilder)builder.connectionFactory(DataSourceConnectionFactoryConfigurationBuilder.class)).setDataSourceDependency((Value<DataSource>)this.dataSourceDepencency);
    }
}

