/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.transform.LegacyPropertyResourceTransformer;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreBuilder;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class MixedKeyedJDBCStoreResourceDefinition
extends JDBCStoreResourceDefinition {
    static final PathElement LEGACY_PATH = PathElement.pathElement((String)"mixed-keyed-jdbc-store", (String)"MIXED_KEYED_JDBC_STORE");
    static final PathElement PATH = MixedKeyedJDBCStoreResourceDefinition.pathElement("mixed-jdbc");

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = InfinispanModel.VERSION_4_0_0.requiresTransformation(version) ? parent.addChildRedirection(PATH, LEGACY_PATH) : parent.addChildResource(PATH);
        JDBCStoreResourceDefinition.buildTransformation(version, builder, PATH);
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            builder.setCustomResourceTransformer(new ResourceTransformer(){

                public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                    ModelNode stringTableModel;
                    ModelNode model = resource.getModel();
                    ModelNode binaryTableModel = Resource.Tools.readModel((Resource)resource.removeChild(BinaryTableResourceDefinition.PATH));
                    if (binaryTableModel != null && binaryTableModel.isDefined()) {
                        model.get(DeprecatedAttribute.BINARY_TABLE.getName()).set(binaryTableModel);
                    }
                    if ((stringTableModel = Resource.Tools.readModel((Resource)resource.removeChild(StringTableResourceDefinition.PATH))) != null && stringTableModel.isDefined()) {
                        model.get(DeprecatedAttribute.STRING_TABLE.getName()).set(stringTableModel);
                    }
                    ModelNode properties = model.remove(StoreResourceDefinition.Attribute.PROPERTIES.getName());
                    ResourceTransformationContext childContext = context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource);
                    LegacyPropertyResourceTransformer.transformPropertiesToChildrenResources((ModelNode)properties, (PathAddress)address, (ResourceTransformationContext)childContext);
                    context.processChildren(resource);
                }
            });
        }
        BinaryTableResourceDefinition.buildTransformation(version, builder);
        StringTableResourceDefinition.buildTransformation(version, builder);
    }

    MixedKeyedJDBCStoreResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(PATH, LEGACY_PATH, new InfinispanResourceDescriptionResolver(PATH, JDBCStoreResourceDefinition.PATH, WILDCARD_PATH), allowRuntimeOnlyRegistration, (ResourceDescriptor descriptor) -> descriptor.addExtraParameters(DeprecatedAttribute.class).addRequiredChildren(new PathElement[]{BinaryTableResourceDefinition.PATH, StringTableResourceDefinition.PATH}).addOperationTranslator((OperationStepHandler)new JDBCStoreResourceDefinition.TableAttributeTranslator(DeprecatedAttribute.BINARY_TABLE, BinaryTableResourceDefinition.PATH)).addOperationTranslator((OperationStepHandler)new JDBCStoreResourceDefinition.TableAttributeTranslator(DeprecatedAttribute.STRING_TABLE, StringTableResourceDefinition.PATH)), (ResourceServiceBuilderFactory<PersistenceConfiguration>)((ResourceServiceBuilderFactory)address -> new MixedKeyedJDBCStoreBuilder(address.getParent())), (ManagementResourceRegistration registration) -> {
            registration.registerReadWriteAttribute(DeprecatedAttribute.BINARY_TABLE.getDefinition(), BinaryKeyedJDBCStoreResourceDefinition.LEGACY_READ_TABLE_HANDLER, BinaryKeyedJDBCStoreResourceDefinition.LEGACY_WRITE_TABLE_HANDLER);
            registration.registerReadWriteAttribute(DeprecatedAttribute.STRING_TABLE.getDefinition(), StringKeyedJDBCStoreResourceDefinition.LEGACY_READ_TABLE_HANDLER, StringKeyedJDBCStoreResourceDefinition.LEGACY_WRITE_TABLE_HANDLER);
            new BinaryTableResourceDefinition().register((ManagementResourceRegistration)registration);
            new StringTableResourceDefinition().register((ManagementResourceRegistration)registration);
        });
        this.setDeprecated(InfinispanModel.VERSION_4_2_0.getVersion());
    }

    @Deprecated
    static enum DeprecatedAttribute implements Attribute
    {
        BINARY_TABLE(BinaryKeyedJDBCStoreResourceDefinition.DeprecatedAttribute.TABLE),
        STRING_TABLE(StringKeyedJDBCStoreResourceDefinition.DeprecatedAttribute.TABLE);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(Attribute attribute) {
            this.definition = (AttributeDefinition)attribute.getDefinition();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

