/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.jboss.as.clustering.controller.AttributeParsers;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreBuilder;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.service.UnaryRequirement;

public class RemoteStoreResourceDefinition
extends StoreResourceDefinition {
    static final PathElement LEGACY_PATH = PathElement.pathElement((String)"remote-store", (String)"REMOTE_STORE");
    static final PathElement PATH = RemoteStoreResourceDefinition.pathElement("remote");

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder;
        ResourceTransformationDescriptionBuilder resourceTransformationDescriptionBuilder = builder = InfinispanModel.VERSION_4_0_0.requiresTransformation(version) ? parent.addChildRedirection(PATH, LEGACY_PATH) : parent.addChildResource(PATH);
        if (InfinispanModel.VERSION_4_0_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultAttributeConverter(){

                protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                    if (attributeValue.isDefined()) {
                        List remoteServers = attributeValue.clone().asList();
                        ModelNode legacyListObject = new ModelNode();
                        for (ModelNode server : remoteServers) {
                            ModelNode legacyListItem = new ModelNode();
                            legacyListItem.get("outbound-socket-binding").set(server);
                            legacyListObject.add(legacyListItem);
                        }
                        attributeValue.set(legacyListObject);
                    }
                }
            }, new AttributeDefinition[]{Attribute.SOCKET_BINDINGS.getDefinition()});
        }
        StoreResourceDefinition.buildTransformation(version, builder, PATH);
    }

    RemoteStoreResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(PATH, LEGACY_PATH, (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver(PATH, WILDCARD_PATH), allowRuntimeOnlyRegistration, descriptor -> descriptor.addAttributes(Attribute.class).addCapabilities(Capability.class), (ResourceServiceBuilderFactory<PersistenceConfiguration>)((ResourceServiceBuilderFactory)address -> new RemoteStoreBuilder(address.getParent())), Consumers.empty());
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        CACHE("cache", ModelType.STRING, new ModelNode("___defaultcache")),
        SOCKET_TIMEOUT("socket-timeout", ModelType.LONG, new ModelNode(60000L)),
        TCP_NO_DELAY("tcp-no-delay", ModelType.BOOLEAN, new ModelNode(true)),
        SOCKET_BINDINGS("remote-servers");

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null))).build();
        }

        private Attribute(String name) {
            this.definition = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(name).setAttributeParser(AttributeParsers.COLLECTION)).setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.OUTBOUND_SOCKET_BINDING, (UnaryRequirement)CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMinSize(1)).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        OUTBOUND_SOCKET_BINDING("org.wildfly.clustering.infinispan.cache-container.cache.store.remote.outbound-socket-binding");

        private final RuntimeCapability<Void> definition;

        private Capability(String name) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true).build();
        }

        public RuntimeCapability<Void> getDefinition() {
            return this.definition;
        }

        public RuntimeCapability<Void> resolve(PathAddress address) {
            PathAddress cacheAddress = address.getParent();
            PathAddress containerAddress = cacheAddress.getParent();
            return this.definition.fromBaseCapability(containerAddress.getLastElement().getValue() + "." + cacheAddress.getLastElement().getValue());
        }
    }
}

