/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;

public class ScheduledThreadPoolBuilder
extends ComponentBuilder<ThreadPoolConfiguration>
implements ResourceServiceBuilder<ThreadPoolConfiguration> {
    private final ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(null);
    private final ScheduledThreadPoolDefinition definition;

    ScheduledThreadPoolBuilder(ScheduledThreadPoolDefinition definition, PathAddress containerAddress) {
        super(definition, containerAddress);
        this.definition = definition;
    }

    public Builder<ThreadPoolConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final int maxThreads = this.definition.getMaxThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt();
        final long keepAliveTime = this.definition.getKeepAliveTime().resolveModelAttribute((ExpressionResolver)context, model).asLong();
        ThreadPoolExecutorFactory<ScheduledExecutorService> factory = new ThreadPoolExecutorFactory<ScheduledExecutorService>(){

            public ScheduledExecutorService createExecutor(ThreadFactory factory) {
                ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(maxThreads, (ThreadFactory)new ClassLoaderThreadFactory(factory, ClassLoaderThreadFactory.class.getClassLoader()));
                executor.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
                executor.setRemoveOnCancelPolicy(true);
                executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                return executor;
            }

            public void validate() {
            }
        };
        this.builder.threadPoolFactory((ThreadPoolExecutorFactory)factory);
        return this;
    }

    public ThreadPoolConfiguration getValue() {
        return this.builder.create();
    }
}

