/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Properties;
import java.util.function.Consumer;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.service.Builder;
import org.wildfly.common.function.ExceptionBiFunction;

public abstract class StoreBuilder<C extends StoreConfiguration, B extends AbstractStoreConfigurationBuilder<C, B>>
extends ComponentBuilder<PersistenceConfiguration>
implements ResourceServiceBuilder<PersistenceConfiguration>,
Consumer<B> {
    private final InjectedValue<AsyncStoreConfiguration> async = new InjectedValue();
    private final PathAddress cacheAddress;
    private final ExceptionBiFunction<OperationContext, ModelNode, B, OperationFailedException> storeBuilderFactory;
    private volatile B storeBuilder;

    StoreBuilder(PathAddress cacheAddress, ExceptionBiFunction<OperationContext, ModelNode, B, OperationFailedException> storeBuilderFactory) {
        super(CacheComponent.PERSISTENCE, cacheAddress);
        this.cacheAddress = cacheAddress;
        this.storeBuilderFactory = storeBuilderFactory;
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.STORE_WRITE.getServiceName(this.cacheAddress), AsyncStoreConfiguration.class, this.async);
    }

    public Builder<PersistenceConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.storeBuilder = (AbstractStoreConfigurationBuilder)this.storeBuilderFactory.apply((Object)context, (Object)model);
        this.storeBuilder.persistence().passivation(StoreResourceDefinition.Attribute.PASSIVATION.resolveModelAttribute((ExpressionResolver)context, model).asBoolean());
        Properties properties = new Properties();
        ModelNodes.optionalPropertyList((ModelNode)StoreResourceDefinition.Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, model)).ifPresent(list -> list.forEach(property -> properties.setProperty(property.getName(), property.getValue().asString())));
        this.storeBuilder.fetchPersistentState(StoreResourceDefinition.Attribute.FETCH_STATE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).preload(StoreResourceDefinition.Attribute.PRELOAD.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).purgeOnStartup(StoreResourceDefinition.Attribute.PURGE.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).shared(StoreResourceDefinition.Attribute.SHARED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).singleton().enabled(StoreResourceDefinition.Attribute.SINGLETON.resolveModelAttribute((ExpressionResolver)context, model).asBoolean()).withProperties(properties);
        return this;
    }

    public final PersistenceConfiguration getValue() {
        this.accept(this.storeBuilder);
        return this.storeBuilder.async().read((AsyncStoreConfiguration)this.async.getValue()).persistence().create();
    }
}

