/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.SingletonPolicy;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.extension.clustering.singleton.ElectionPolicyServiceNameProvider;
import org.wildfly.extension.clustering.singleton.SingletonPolicyResourceDefinition;

public class SingletonPolicyBuilder
implements ResourceServiceBuilder<SingletonPolicy>,
SingletonPolicy {
    private final InjectedValue<SingletonElectionPolicy> policy = new InjectedValue();
    private final PathAddress address;
    private volatile ValueDependency<SingletonServiceBuilderFactory> factory;
    private volatile int quorum;

    public SingletonPolicyBuilder(PathAddress address) {
        this.address = address;
    }

    public ServiceName getServiceName() {
        return SingletonPolicyResourceDefinition.Capability.POLICY.getServiceName(this.address);
    }

    public ServiceBuilder<SingletonPolicy> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)new ImmediateValue((Object)this))).addDependency(new ElectionPolicyServiceNameProvider(this.address).getServiceName(), SingletonElectionPolicy.class, this.policy).setInitialMode(ServiceController.Mode.PASSIVE);
        return this.factory.register(builder);
    }

    public Builder<SingletonPolicy> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String containerName = SingletonPolicyResourceDefinition.Attribute.CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        String cacheName = ModelNodes.optionalString((ModelNode)SingletonPolicyResourceDefinition.Attribute.CACHE.resolveModelAttribute((ExpressionResolver)context, model)).orElse(null);
        this.factory = new InjectedValueDependency(ClusteringCacheRequirement.SINGLETON_SERVICE_BUILDER_FACTORY.getServiceName(context, containerName, cacheName), SingletonServiceBuilderFactory.class);
        this.quorum = SingletonPolicyResourceDefinition.Attribute.QUORUM.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        return this;
    }

    public <T> Builder<T> createSingletonServiceBuilder(ServiceName name, Service<T> service) {
        return ((SingletonServiceBuilderFactory)this.factory.getValue()).createSingletonServiceBuilder(name, service).electionPolicy((SingletonElectionPolicy)this.policy.getValue()).requireQuorum(this.quorum);
    }

    public <T> Builder<T> createSingletonServiceBuilder(ServiceName name, Service<T> primaryService, Service<T> backupService) {
        return ((SingletonServiceBuilderFactory)this.factory.getValue()).createSingletonServiceBuilder(name, primaryService, backupService).electionPolicy((SingletonElectionPolicy)this.policy.getValue()).requireQuorum(this.quorum);
    }
}

