/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import org.jboss.as.clustering.controller.CapabilityProvider;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.DefaultableCapabilityReference;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.controller.UnaryRequirementCapability;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.service.DefaultableBinaryRequirement;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;
import org.wildfly.clustering.singleton.SingletonRequirement;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringDefaultCacheRequirement;
import org.wildfly.extension.clustering.singleton.RandomElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SimpleElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.SingletonModel;
import org.wildfly.extension.clustering.singleton.SingletonPolicyBuilder;
import org.wildfly.extension.clustering.singleton.SingletonResourceDescriptionResolver;

public class SingletonPolicyResourceDefinition
extends ChildResourceDefinition {
    static final PathElement WILDCARD_PATH = SingletonPolicyResourceDefinition.pathElement("*");

    static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"singleton-policy", (String)value);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        if (SingletonModel.VERSION_2_0_0.requiresTransformation(version)) {
            ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Attribute.CACHE.getDefinition(), Attribute.CACHE_CONTAINER.getDefinition()})).end();
        }
    }

    SingletonPolicyResourceDefinition() {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new SingletonResourceDescriptionResolver(WILDCARD_PATH));
    }

    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class).addCapabilities(Capability.class).addRequiredSingletonChildren(new PathElement[]{SimpleElectionPolicyResourceDefinition.PATH});
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler(address -> new SingletonPolicyBuilder(address));
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register(registration);
        new RandomElectionPolicyResourceDefinition().register(registration);
        new SimpleElectionPolicyResourceDefinition().register(registration);
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        CACHE_CONTAINER("cache-container", ModelType.STRING, new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.DEFAULT_BUILDER, (UnaryRequirement)ClusteringDefaultCacheRequirement.SINGLETON_SERVICE_BUILDER_FACTORY)),
        CACHE("cache", ModelType.STRING, new DefaultableCapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.BUILDER, (DefaultableBinaryRequirement)ClusteringCacheRequirement.SINGLETON_SERVICE_BUILDER_FACTORY, (org.jboss.as.clustering.controller.Attribute)CACHE_CONTAINER)),
        QUORUM("quorum", ModelType.INT, new ModelNode(1), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(1));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, DefaultableCapabilityReference reference) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type).setRequired(false)).setCapabilityReference((CapabilityReferenceRecorder)reference)).build();
        }

        private Attribute(String name, ModelType type, CapabilityReference reference) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type).setRequired(true)).setCapabilityReference((CapabilityReferenceRecorder)reference)).build();
        }

        private Attribute(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validator) {
            SimpleAttributeDefinitionBuilder builder = (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)Attribute.createBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue);
            this.definition = ((SimpleAttributeDefinitionBuilder)builder.setValidator(validator.configure((AbstractAttributeDefinitionBuilder)builder).build())).build();
        }

        private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type) {
            return (SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES});
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Capability implements CapabilityProvider
    {
        POLICY((UnaryRequirement)SingletonRequirement.SINGLETON_POLICY),
        DEFAULT_BUILDER("org.wildfly.clustering.singleton.policy.default-builder"),
        BUILDER("org.wildfly.clustering.singleton.policy.builder");

        private final org.jboss.as.clustering.controller.Capability capability;

        private Capability(String name) {
            this.capability = () -> RuntimeCapability.Builder.of((String)name, (boolean)true).build();
        }

        private Capability(UnaryRequirement requirement) {
            this.capability = new UnaryRequirementCapability(requirement, new Requirement[0]);
        }

        public org.jboss.as.clustering.controller.Capability getCapability() {
            return this.capability;
        }
    }
}

