/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.session;

import java.util.EnumSet;
import java.util.function.Predicate;
import org.wildfly.clustering.ee.CollectionImmutability;
import org.wildfly.clustering.ee.Immutability;
import org.wildfly.clustering.web.annotation.Immutable;

public enum SessionAttributeImmutability implements Predicate<Object>
{
    JDK{

        @Override
        public boolean test(Object object) {
            return EnumSet.complementOf(EnumSet.of(Immutability.COLLECTION)).stream().anyMatch(predicate -> predicate.test(object));
        }
    }
    ,
    COLLECTION{

        @Override
        public boolean test(Object object) {
            return COLLECTION_INSTANCE.test(object);
        }
    }
    ,
    ANNOTATION{

        @Override
        public boolean test(Object object) {
            return object.getClass().isAnnotationPresent(Immutable.class);
        }
    };

    public static final Predicate<Object> INSTANCE;
    static final Predicate<Object> COLLECTION_INSTANCE;

    static {
        INSTANCE = object -> EnumSet.allOf(SessionAttributeImmutability.class).stream().anyMatch(predicate -> predicate.test(object));
        COLLECTION_INSTANCE = new CollectionImmutability(INSTANCE);
    }
}

