/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.util;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

public final class AggregateServerMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private final HttpServerAuthenticationMechanismFactory[] factories;

    public AggregateServerMechanismFactory(HttpServerAuthenticationMechanismFactory ... factories) {
        this.factories = (HttpServerAuthenticationMechanismFactory[])Assert.checkNotNullParam((String)"factories", (Object)factories);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> properties) {
        LinkedHashSet availableMechanisms = new LinkedHashSet();
        for (HttpServerAuthenticationMechanismFactory current : this.factories) {
            if (current == null) continue;
            Collections.addAll(availableMechanisms, current.getMechanismNames(properties));
        }
        return availableMechanisms.toArray(new String[availableMechanisms.size()]);
    }

    @Override
    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        for (HttpServerAuthenticationMechanismFactory current : this.factories) {
            HttpServerAuthenticationMechanism mechanism;
            if (current == null || (mechanism = current.createAuthenticationMechanism(mechanismName, properties, callbackHandler)) == null) continue;
            return mechanism;
        }
        return null;
    }
}

