/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.command.map;

import java.util.Objects;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.internal.ProcessedOption;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.populator.CommandPopulator;
import org.jboss.aesh.cl.validator.OptionValidatorException;
import org.jboss.aesh.console.AeshContext;
import org.jboss.aesh.console.InvocationProviders;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.map.MapCommand;

class MapCommandPopulator
implements CommandPopulator<Object, Command> {
    private final MapCommand instance;

    MapCommandPopulator(MapCommand instance) {
        Objects.requireNonNull(instance);
        this.instance = instance;
    }

    @Override
    public void populateObject(CommandLine<Command> line, InvocationProviders invocationProviders, AeshContext aeshContext, boolean validate) throws CommandLineParserException, OptionValidatorException {
        if (line.hasParserError()) {
            throw line.getParserException();
        }
        for (ProcessedOption option : line.getParser().getProcessedCommand().getOptions()) {
            if (line.hasOption(option.getName())) {
                ProcessedOption o = line.getOption(option.getName());
                this.instance.setValue(o.getName(), o.doConvert(o.getValue(), invocationProviders, this.instance, aeshContext, validate));
                continue;
            }
            if (option.getDefaultValues().size() > 0) {
                this.instance.setValue(option.getName(), option.doConvert(option.getDefaultValues().get(0), invocationProviders, this.instance, aeshContext, validate));
                continue;
            }
            this.instance.resetValue(option.getName());
        }
        if (line.getArgument() != null && line.getArgument().getValues().size() > 0 || line.getParser().getProcessedCommand().getArgument() != null && line.getParser().getProcessedCommand().getArgument().getDefaultValues().size() > 0) {
            String val = line.getArgument().getValue();
            if (val == null) {
                this.instance.setValue(line.getArgument().getName(), line.getArgument().doConvert(line.getArgument().getDefaultValues().get(0), invocationProviders, this.instance, aeshContext, validate));
            } else {
                this.instance.setValue(line.getArgument().getName(), line.getArgument().doConvert(line.getArgument().getValue(), invocationProviders, this.instance, aeshContext, validate));
            }
        } else if (line.getArgument() != null) {
            this.instance.resetValue(line.getArgument().getName());
        }
    }

    @Override
    public Object getObject() {
        return this.instance;
    }
}

