/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.logging.NamingLogger;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.subsystem.BindingType;
import org.jboss.as.naming.subsystem.NamingBindingAdd;
import org.jboss.as.naming.subsystem.NamingBindingRemove;
import org.jboss.as.naming.subsystem.NamingExtension;
import org.jboss.as.naming.subsystem.NamingSubsystemModel;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class NamingBindingResourceDefinition
extends SimpleResourceDefinition {
    static final NamingBindingResourceDefinition INSTANCE = new NamingBindingResourceDefinition();
    static final SimpleAttributeDefinition BINDING_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("binding-type", ModelType.STRING, false).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setValidator((ParameterValidator)EnumValidator.create(BindingType.class, (boolean)false, (boolean)false))).build();
    static final SimpleAttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("type", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition CLASS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("class", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition LOOKUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("lookup", ModelType.STRING, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final PropertiesAttributeDefinition ENVIRONMENT = ((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("environment", true).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition CACHE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("cache", ModelType.BOOLEAN, true).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{BINDING_TYPE, VALUE, TYPE, CLASS, MODULE, LOOKUP, ENVIRONMENT, CACHE};
    private static final List<AccessConstraintDefinition> ACCESS_CONSTRAINTS;
    static final OperationStepHandler VALIDATE_RESOURCE_MODEL_OPERATION_STEP_HANDLER;

    private NamingBindingResourceDefinition() {
        super(NamingSubsystemModel.BINDING_PATH, NamingExtension.getResourceDescriptionResolver("binding"), (OperationStepHandler)NamingBindingAdd.INSTANCE, (OperationStepHandler)NamingBindingRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler writeHandler = new WriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeHandler);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder("rebind", this.getResourceDescriptionResolver()).addParameter((AttributeDefinition)BINDING_TYPE).addParameter((AttributeDefinition)TYPE).addParameter((AttributeDefinition)VALUE).addParameter((AttributeDefinition)CLASS).addParameter((AttributeDefinition)MODULE).addParameter((AttributeDefinition)LOOKUP).addParameter((AttributeDefinition)ENVIRONMENT);
        resourceRegistration.registerOperationHandler((OperationDefinition)builder.build(), new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        NamingBindingResourceDefinition.validateResourceModel(operation, false);
                        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
                        ModelNode model = resource.getModel();
                        for (AttributeDefinition attr : ATTRIBUTES) {
                            attr.validateAndSet(operation, model);
                        }
                        context.addStep(new OperationStepHandler(){

                            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                                String name = context.getCurrentAddressValue();
                                ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor(name);
                                ServiceController service = context.getServiceRegistry(false).getService(bindInfo.getBinderServiceName());
                                if (service == null) {
                                    context.reloadRequired();
                                    return;
                                }
                                NamingBindingAdd.INSTANCE.doRebind(context, operation, (BinderService)service.getService());
                            }
                        }, OperationContext.Stage.RUNTIME);
                    }
                }, OperationContext.Stage.MODEL);
            }
        });
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return ACCESS_CONSTRAINTS;
    }

    public void registerTransformers_2_0(ResourceTransformationDescriptionBuilder builder) {
        builder.addOperationTransformationOverride("rebind").setReject();
    }

    static void validateResourceModel(ModelNode modelNode, boolean allowExternal) throws OperationFailedException {
        BindingType type = BindingType.forName(modelNode.require("binding-type").asString());
        if (type == BindingType.SIMPLE) {
            if (!modelNode.hasDefined(VALUE.getName())) {
                throw NamingLogger.ROOT_LOGGER.bindingTypeRequiresAttributeDefined(type, VALUE.getName());
            }
            if (modelNode.hasDefined(CACHE.getName()) && modelNode.get(CACHE.getName()).asBoolean()) {
                throw NamingLogger.ROOT_LOGGER.cacheNotValidForBindingType(type);
            }
        } else if (type == BindingType.OBJECT_FACTORY) {
            if (!modelNode.hasDefined(MODULE.getName())) {
                throw NamingLogger.ROOT_LOGGER.bindingTypeRequiresAttributeDefined(type, MODULE.getName());
            }
            if (!modelNode.hasDefined(CLASS.getName())) {
                throw NamingLogger.ROOT_LOGGER.bindingTypeRequiresAttributeDefined(type, CLASS.getName());
            }
            if (modelNode.hasDefined(CACHE.getName()) && modelNode.get(CACHE.getName()).asBoolean()) {
                throw NamingLogger.ROOT_LOGGER.cacheNotValidForBindingType(type);
            }
        } else if (type == BindingType.EXTERNAL_CONTEXT) {
            if (!allowExternal) {
                throw NamingLogger.ROOT_LOGGER.cannotRebindExternalContext();
            }
            if (!modelNode.hasDefined(MODULE.getName())) {
                throw NamingLogger.ROOT_LOGGER.bindingTypeRequiresAttributeDefined(type, MODULE.getName());
            }
            if (!modelNode.hasDefined(CLASS.getName())) {
                throw NamingLogger.ROOT_LOGGER.bindingTypeRequiresAttributeDefined(type, CLASS.getName());
            }
        } else if (type == BindingType.LOOKUP) {
            if (!modelNode.hasDefined(LOOKUP.getName())) {
                throw NamingLogger.ROOT_LOGGER.bindingTypeRequiresAttributeDefined(type, LOOKUP.getName());
            }
            if (modelNode.hasDefined(CACHE.getName()) && modelNode.get(CACHE.getName()).asBoolean()) {
                throw NamingLogger.ROOT_LOGGER.cacheNotValidForBindingType(type);
            }
        } else {
            throw NamingLogger.ROOT_LOGGER.unknownBindingType(type.toString());
        }
    }

    static {
        ArrayList<Object> constraints = new ArrayList<Object>();
        constraints.add(NamingExtension.NAMING_BINDING_APPLICATION_CONSTRAINT);
        constraints.add(NamingExtension.NAMING_BINDING_SENSITIVITY_CONSTRAINT);
        ACCESS_CONSTRAINTS = Collections.unmodifiableList(constraints);
        VALIDATE_RESOURCE_MODEL_OPERATION_STEP_HANDLER = (context, op) -> NamingBindingResourceDefinition.validateResourceModel(context.readResource(PathAddress.EMPTY_ADDRESS).getModel(), true);
    }

    private static class WriteAttributeHandler
    extends ReloadRequiredWriteAttributeHandler {
        private WriteAttributeHandler(AttributeDefinition ... definitions) {
            super(definitions);
        }

        protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
            super.validateUpdatedModel(context, model);
            context.addStep(VALIDATE_RESOURCE_MODEL_OPERATION_STEP_HANDLER, OperationContext.Stage.MODEL);
        }
    }
}

