/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.wildfly.clustering.marshalling.Externalizer;

public abstract class IndexExternalizer
extends Enum<IndexExternalizer>
implements Externalizer<Integer> {
    public static final /* enum */ IndexExternalizer UNSIGNED_BYTE = new IndexExternalizer(){

        @Override
        public int readData(DataInput input) throws IOException {
            return input.readUnsignedByte();
        }

        @Override
        public void writeData(DataOutput output, int index) throws IOException {
            if (index > 255) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            output.writeByte(index);
        }
    };
    public static final /* enum */ IndexExternalizer UNSIGNED_SHORT = new IndexExternalizer(){

        @Override
        public int readData(DataInput input) throws IOException {
            return input.readUnsignedShort();
        }

        @Override
        public void writeData(DataOutput output, int index) throws IOException {
            if (index > 65535) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            output.writeShort(index);
        }
    };
    public static final /* enum */ IndexExternalizer INTEGER = new IndexExternalizer(){

        @Override
        public int readData(DataInput input) throws IOException {
            return input.readInt();
        }

        @Override
        public void writeData(DataOutput output, int index) throws IOException {
            output.writeInt(index);
        }
    };
    public static final /* enum */ IndexExternalizer VARIABLE = new IndexExternalizer(){

        @Override
        public int readData(DataInput input) throws IOException {
            byte b = input.readByte();
            int i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                b = input.readByte();
                i = (int)((long)i | ((long)b & 0x7FL) << shift);
                shift += 7;
            }
            return i;
        }

        @Override
        public void writeData(DataOutput output, int index) throws IOException {
            int i = index;
            while ((i & 0xFFFFFF80) != 0) {
                output.writeByte((byte)(i & 0x7F | 0x80));
                i >>>= 7;
            }
            output.writeByte((byte)i);
        }
    };
    private static final /* synthetic */ IndexExternalizer[] $VALUES;

    public static IndexExternalizer[] values() {
        return (IndexExternalizer[])$VALUES.clone();
    }

    public static IndexExternalizer valueOf(String name) {
        return Enum.valueOf(IndexExternalizer.class, name);
    }

    public static final IndexExternalizer select(int size) {
        if (size <= 255) {
            return UNSIGNED_BYTE;
        }
        if (size <= 65535) {
            return UNSIGNED_SHORT;
        }
        return VARIABLE;
    }

    public abstract int readData(DataInput var1) throws IOException;

    public abstract void writeData(DataOutput var1, int var2) throws IOException;

    public Integer readObject(ObjectInput input) throws IOException {
        return this.readData(input);
    }

    public void writeObject(ObjectOutput output, Integer index) throws IOException {
        assert (index != null);
        this.writeData(output, index);
    }

    public Class<Integer> getTargetClass() {
        return Integer.class;
    }

    static {
        $VALUES = new IndexExternalizer[]{UNSIGNED_BYTE, UNSIGNED_SHORT, INTEGER, VARIABLE};
    }
}

