/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.wildfly.clustering.service.BinaryRequirement;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;

public class CapabilityReference
implements CapabilityReferenceRecorder {
    private final Capability capability;
    private final Requirement requirement;
    private final BiFunction<OperationContext, String, Optional<String>> requirementResolver;

    public CapabilityReference(Capability capability, UnaryRequirement requirement) {
        this(capability, (Requirement)requirement, (OperationContext context, String value) -> value != null ? Optional.of(requirement.resolve(value)) : Optional.empty());
    }

    public CapabilityReference(Capability capability, BinaryRequirement requirement) {
        this(capability, requirement, (OperationContext context) -> context.getCurrentAddressValue());
    }

    public CapabilityReference(Capability capability, BinaryRequirement requirement, Attribute parentAttribute) {
        this(capability, requirement, (OperationContext context) -> context.readResource(PathAddress.EMPTY_ADDRESS, false).getModel().get(parentAttribute.getName()).asString());
    }

    public CapabilityReference(Capability capability, BinaryRequirement requirement, Function<OperationContext, String> parentResolver) {
        this(capability, (Requirement)requirement, (OperationContext context, String value) -> value != null ? Optional.of(requirement.resolve((String)parentResolver.apply((OperationContext)context), value)) : Optional.empty());
    }

    CapabilityReference(Capability capability, Requirement requirement, BiFunction<OperationContext, String, Optional<String>> requirementResolver) {
        this.capability = capability;
        this.requirement = requirement;
        this.requirementResolver = requirementResolver;
    }

    public void addCapabilityRequirements(OperationContext context, String attributeName, String ... values) {
        String dependentName = this.capability.resolve(context.getCurrentAddress()).getName();
        Stream.of(values).forEach(value -> this.requirementResolver.apply(context, (String)value).ifPresent(requirementName -> context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName)));
    }

    public void removeCapabilityRequirements(OperationContext context, String attributeName, String ... values) {
        String dependentName = this.capability.resolve(context.getCurrentAddress()).getName();
        Stream.of(values).forEach(value -> this.requirementResolver.apply(context, (String)value).ifPresent(requirementName -> context.deregisterCapabilityRequirement(requirementName, dependentName)));
    }

    public String getBaseDependentName() {
        return ((RuntimeCapability)this.capability.getDefinition()).getName();
    }

    public String getBaseRequirementName() {
        return this.requirement.getName();
    }

    public boolean isDynamicDependent() {
        return ((RuntimeCapability)this.capability.getDefinition()).isDynamicallyNamed();
    }

    public int hashCode() {
        return this.getBaseDependentName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof CapabilityReferenceRecorder)) {
            return false;
        }
        CapabilityReference reference = (CapabilityReference)object;
        return ((RuntimeCapability)this.capability.getDefinition()).getName().equals(((RuntimeCapability)reference.capability.getDefinition()).getName());
    }
}

