/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLContext;
import javax.security.sasl.SaslClientFactory;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.ManagedConnection;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

class FutureConnection {
    private final EndpointImpl endpoint;
    private final URI uri;
    private final String realHost;
    private final int realPort;
    private final AtomicReference<FutureResult<Connection>> futureConnectionRef = new AtomicReference();
    private final boolean immediate;
    private final OptionMap options;
    private final AuthenticationConfiguration configuration;
    private final UnaryOperator<SaslClientFactory> clientFactoryOperator;
    private final SSLContext sslContext;
    private final SocketAddress bindAddress;

    FutureConnection(EndpointImpl endpoint, SocketAddress bindAddress, URI uri, String realHost, int realPort, boolean immediate, OptionMap options, AuthenticationConfiguration configuration, UnaryOperator<SaslClientFactory> clientFactoryOperator, SSLContext sslContext) {
        this.endpoint = endpoint;
        this.bindAddress = bindAddress;
        this.uri = uri;
        this.realHost = realHost;
        this.realPort = realPort;
        this.immediate = immediate;
        this.options = options;
        this.configuration = configuration;
        this.clientFactoryOperator = clientFactoryOperator;
        this.sslContext = sslContext;
    }

    void reconnectAfterDelay() {
        this.endpoint.getXnioWorker().getIoThread().executeAfter(() -> this.init(true), 30L, TimeUnit.SECONDS);
    }

    IoFuture<Connection> init(boolean connect) {
        return this.getConnection(null, connect);
    }

    void splice(final FutureResult<Connection> futureResult, IoFuture<Connection> realFuture) {
        futureResult.addCancelHandler(realFuture);
        realFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Connection, FutureResult<Connection>>(){

            public void handleCancelled(FutureResult<Connection> attachment) {
                attachment.setCancelled();
            }

            public void handleFailed(IOException exception, FutureResult<Connection> attachment) {
                attachment.setException(exception);
            }

            public void handleDone(Connection data, FutureResult<Connection> attachment) {
                attachment.setResult((Object)new ManagedConnection(data, FutureConnection.this, (FutureResult<Connection>)futureResult));
            }
        }, futureResult);
    }

    IoFuture<Connection> getConnection(FutureResult<Connection> orig, boolean connect) {
        AtomicReference<FutureResult<Connection>> futureConnectionRef = this.futureConnectionRef;
        FutureResult<Connection> oldVal = futureConnectionRef.get();
        if (oldVal != orig) {
            return oldVal.getIoFuture();
        }
        if (!connect) {
            return null;
        }
        final FutureResult futureResult = new FutureResult();
        while (!futureConnectionRef.compareAndSet(oldVal, (FutureResult<Connection>)futureResult)) {
            oldVal = futureConnectionRef.get();
            if (oldVal == orig) continue;
            return oldVal.getIoFuture();
        }
        IoFuture<Connection> realFuture = this.endpoint.connect(this.uri, this.bindAddress, this.options, this.configuration, this.clientFactoryOperator, this.sslContext);
        this.splice((FutureResult<Connection>)futureResult, realFuture);
        IoFuture ioFuture = futureResult.getIoFuture();
        ioFuture.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<Connection, FutureConnection>(){

            public void handleCancelled(FutureConnection attachment) {
                attachment.futureConnectionRef.set(null);
                if (attachment.immediate) {
                    attachment.reconnectAfterDelay();
                }
            }

            public void handleFailed(IOException exception, FutureConnection attachment) {
                attachment.futureConnectionRef.set(null);
                if (attachment.immediate) {
                    attachment.reconnectAfterDelay();
                }
            }

            public void handleDone(Connection connection, FutureConnection attachment) {
                connection.addCloseHandler((closed, exception) -> {
                    FutureConnection.this.clearRef((FutureResult<Connection>)futureResult);
                    if (attachment.immediate) {
                        attachment.getConnection((FutureResult<Connection>)((FutureResult)attachment.futureConnectionRef.get()), true);
                    }
                });
            }
        }, (Object)this);
        return ioFuture;
    }

    void clearRef(FutureResult<Connection> futureResult) {
        this.futureConnectionRef.compareAndSet(futureResult, null);
    }

    public IoFuture<Connection> get(boolean connect) {
        return this.init(connect);
    }

    boolean isConnected() {
        FutureResult<Connection> futureResult = this.futureConnectionRef.get();
        return futureResult != null && futureResult.getIoFuture().getStatus() == IoFuture.Status.DONE;
    }
}

