/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.protocol.ProtocolFactory;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.service.Builder;

public abstract class AbstractProtocolConfigurationBuilder<P extends Protocol, C extends ProtocolConfiguration<P>>
implements ResourceServiceBuilder<C>,
Value<C>,
ProtocolConfiguration<P>,
Consumer<P> {
    private final String name;
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final InjectedValue<ProtocolDefaults> defaults = new InjectedValue();
    private volatile Map<String, String> properties;
    private volatile String moduleName;
    private volatile Boolean statisticsEnabled;

    protected AbstractProtocolConfigurationBuilder(String name) {
        this.name = name;
    }

    public ServiceBuilder<C> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).addDependency(ProtocolDefaultsBuilder.SERVICE_NAME, ProtocolDefaults.class, this.defaults).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public Builder<C> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.moduleName = AbstractProtocolResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.properties = ModelNodes.optionalPropertyList((ModelNode)AbstractProtocolResourceDefinition.Attribute.PROPERTIES.resolveModelAttribute((ExpressionResolver)context, model)).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(Property::getName, property -> property.getValue().asString()));
        this.statisticsEnabled = AbstractProtocolResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBooleanOrNull();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public final P createProtocol(ProtocolStackConfiguration stackConfiguration) {
        StringBuilder builder = new StringBuilder();
        if (this.moduleName.equals(AbstractProtocolResourceDefinition.Attribute.MODULE.getDefinition().getDefaultValue().asString()) && !this.name.startsWith("org.jgroups.protocols")) {
            builder.append("org.jgroups.protocols").append('.');
        }
        String className = builder.append(this.name).toString();
        try {
            Module module = ((ModuleLoader)this.loader.getValue()).loadModule(this.moduleName);
            Class<Protocol> protocolClass = module.getClassLoader().loadClass(className).asSubclass(Protocol.class);
            Protocol protocol = ProtocolFactory.newInstance(protocolClass);
            Protocol result = ProtocolFactory.TRANSFORMER.apply(protocol);
            HashMap<String, String> properties = new HashMap<String, String>(((ProtocolDefaults)this.defaults.getValue()).getProperties(this.name));
            properties.putAll(this.properties);
            Configurator.resolveAndAssignFields((Object)result, properties);
            Configurator.resolveAndInvokePropertyMethods((Object)result, properties);
            this.accept(result);
            result.enableStats(this.statisticsEnabled != null ? this.statisticsEnabled.booleanValue() : stackConfiguration.isStatisticsEnabled());
            return (P)result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

