/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.modules.JDKPaths;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.filter.PathFilter;

public final class PathUtils {
    private PathUtils() {
    }

    public static <T extends Collection<? super String>> T filterPaths(Iterable<String> source, PathFilter filter, T target) {
        for (String path : source) {
            if (!filter.accept(path)) continue;
            target.add((String)path);
        }
        return target;
    }

    public static Set<String> getPathSet(ClassLoader classLoader) {
        if (classLoader == null) {
            return JDKPaths.JDK;
        }
        if (classLoader instanceof ModuleClassLoader) {
            ModuleClassLoader moduleClassLoader = (ModuleClassLoader)classLoader;
            return Collections.unmodifiableSet(moduleClassLoader.getPaths());
        }
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            URL[] urls = urlClassLoader.getURLs();
            HashSet<String> paths = new HashSet<String>();
            for (URL url : urls) {
                File file;
                URI uri;
                try {
                    uri = url.toURI();
                }
                catch (URISyntaxException e) {
                    return null;
                }
                String scheme = uri.getScheme();
                if (!"file".equals(scheme)) continue;
                try {
                    file = new File(uri);
                }
                catch (Exception e) {
                    return null;
                }
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    JDKPaths.processDirectory(paths, file);
                    continue;
                }
                try {
                    JDKPaths.processJar(paths, file);
                }
                catch (IOException e) {
                    return null;
                }
            }
            return Collections.unmodifiableSet(paths);
        }
        return null;
    }

    public static String relativize(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '/' || path.charAt(i) == File.separatorChar) continue;
            return i == 0 ? path : path.substring(i);
        }
        return "";
    }

    public static String canonicalize(String path) {
        int length = path.length();
        int state = 0;
        if (length == 0) {
            return path;
        }
        char[] targetBuf = new char[length];
        int e = length;
        int i = length;
        int a = length - 1;
        int skip = 0;
        block22: while (--i >= 0) {
            char c = path.charAt(i);
            block0 : switch (c) {
                case '/': {
                    switch (state) {
                        case 0: {
                            state = 3;
                            e = i;
                            continue block22;
                        }
                        case 1: {
                            state = 3;
                            e = i;
                            continue block22;
                        }
                        case 2: {
                            state = 3;
                            e = i;
                            ++skip;
                            continue block22;
                        }
                        case 3: {
                            e = i;
                            continue block22;
                        }
                    }
                    throw new IllegalStateException();
                }
                case '.': {
                    switch (state) {
                        case 0: {
                            state = 1;
                            continue block22;
                        }
                        case 1: {
                            state = 2;
                            continue block22;
                        }
                        case 2: {
                            break block0;
                        }
                        case 3: {
                            state = 1;
                            continue block22;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            if (File.separatorChar != '/' && c == File.separatorChar) {
                switch (state) {
                    case 0: {
                        state = 3;
                        e = i;
                        continue block22;
                    }
                    case 1: {
                        state = 3;
                        e = i;
                        continue block22;
                    }
                    case 2: {
                        state = 3;
                        e = i;
                        ++skip;
                        continue block22;
                    }
                    case 3: {
                        e = i;
                        continue block22;
                    }
                }
                throw new IllegalStateException();
            }
            int newE = e > 0 ? path.lastIndexOf(47, e - 1) : -1;
            int segmentLength = e - newE - 1;
            if (skip > 0) {
                --skip;
            } else {
                if (state == 3) {
                    targetBuf[a--] = 47;
                }
                path.getChars(newE + 1, e, targetBuf, (a -= segmentLength) + 1);
            }
            state = 0;
            i = newE + 1;
            e = newE;
        }
        if (state == 3) {
            targetBuf[a--] = 47;
        }
        return new String(targetBuf, a + 1, length - a - 1);
    }

    public static boolean isChild(String parent, String child) {
        String cp = PathUtils.canonicalize(parent);
        cp = cp.endsWith("/") ? cp.substring(0, cp.length() - 1) : cp;
        String cc = PathUtils.canonicalize(child);
        if (PathUtils.isRelative(cp) != PathUtils.isRelative(cc)) {
            throw new IllegalArgumentException("Cannot compare relative and absolute paths");
        }
        int cpl = cp.length();
        return cpl == 0 || cc.length() > cpl + 1 && cc.startsWith(cp) && cc.charAt(cpl) == '/';
    }

    public static boolean isDirectChild(String parent, String child) {
        String cp = PathUtils.canonicalize(parent);
        cp = cp.endsWith("/") ? cp.substring(0, cp.length() - 1) : cp;
        String cc = PathUtils.canonicalize(child);
        if (PathUtils.isRelative(cp) != PathUtils.isRelative(cc)) {
            throw new IllegalArgumentException("Cannot compare relative and absolute paths");
        }
        int cpl = cp.length();
        if (cpl == 0) {
            return cc.indexOf(47) < 0;
        }
        return cc.length() > cpl + 1 && cc.startsWith(cp) && cc.charAt(cpl) == '/' && cc.indexOf(47, cpl + 1) == -1;
    }

    public static boolean isRelative(String path) {
        return path.isEmpty() || !PathUtils.isSeparator(path.charAt(0));
    }

    public static boolean isSeparator(char ch) {
        return ch == '/' || File.separatorChar != '/' && ch == File.separatorChar;
    }
}

