/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.ha.SharedStoreMasterPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;
import org.jboss.logging.Logger;

public final class SharedStoreLiveActivation
extends LiveActivation {
    private static final Logger logger = Logger.getLogger(SharedStoreLiveActivation.class);
    private SharedStoreMasterPolicy sharedStoreMasterPolicy;
    private ActiveMQServerImpl activeMQServer;

    public SharedStoreLiveActivation(ActiveMQServerImpl server, SharedStoreMasterPolicy sharedStoreMasterPolicy) {
        this.activeMQServer = server;
        this.sharedStoreMasterPolicy = sharedStoreMasterPolicy;
    }

    @Override
    public void run() {
        try {
            ActiveMQServerLogger.LOGGER.awaitingLiveLock();
            this.activeMQServer.checkJournalDirectory();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("First part initialization on " + this));
            }
            if (!this.activeMQServer.initialisePart1(false)) {
                return;
            }
            if (this.activeMQServer.getNodeManager().isBackupLive()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("announcing backup to the former live" + this));
                }
                this.activeMQServer.getBackupManager().start();
                this.activeMQServer.getBackupManager().announceBackup();
            }
            this.activeMQServer.registerActivateCallback(this.activeMQServer.getNodeManager().startLiveNode());
            if (this.activeMQServer.getState() == ActiveMQServerImpl.SERVER_STATE.STOPPED || this.activeMQServer.getState() == ActiveMQServerImpl.SERVER_STATE.STOPPING) {
                return;
            }
            this.activeMQServer.initialisePart2(false);
            this.activeMQServer.completeActivation();
            ActiveMQServerLogger.LOGGER.serverIsLive();
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.initializationError(e);
            this.activeMQServer.callActivationFailureListeners(e);
        }
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        NodeManager nodeManagerInUse = this.activeMQServer.getNodeManager();
        if (nodeManagerInUse != null) {
            if (this.sharedStoreMasterPolicy.isFailoverOnServerShutdown() || permanently) {
                nodeManagerInUse.crashLiveServer();
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }
}

