/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.logging;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Handler;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.logging.Target;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;
import org.jboss.logging.annotations.Transform;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;

@MessageLogger(projectCode="WFLYLOG", length=4)
public interface LoggingLogger
extends BasicLogger {
    public static final LoggingLogger ROOT_LOGGER = (LoggingLogger)Logger.getMessageLogger(LoggingLogger.class, (String)"org.jboss.as.logging");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="An error occurred trying to set the property '%s' on handler '%s'.")
    public void errorSettingProperty(@Cause Throwable var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Unknown property '%s' for '%s'.")
    public void unknownProperty(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Failed to close resource %s")
    public void failedToCloseResource(@Cause Throwable var1, Closeable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="The attribute %s could not be set as it is not a configurable property value.")
    public void invalidPropertyAttribute(String var1);

    @Message(id=8, value="The path manager service does not appear to be started. Any changes may be lost as a result of this.")
    public String pathManagerServiceNotStarted();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="Filters are not currently supported for log4j appenders.")
    public void filterNotSupported();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Logging profile '%s' was specified for deployment '%s' but was not found. Using system logging configuration.")
    public void loggingProfileNotFound(String var1, ResourceRoot var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11, value="The configuration file in '%s' appears to be a J.U.L. configuration file. The log manager does not allow this type of configuration file.")
    public void julConfigurationFileFound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=12, value="Replacing handler '%s' during add operation. Either the handler type or the module name differs from the initial configuration.")
    public void replacingNamedHandler(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="A configurator class, '%s', is not a known configurator and will be replaced.")
    public void replacingConfigurator(@Transform(value={Transform.TransformType.GET_CLASS}) Configurator var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="The log context (%s) could not be removed for deployment %s")
    public void logContextNotRemoved(LogContext var1, String var2);

    @Deprecated
    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="The per-logging deployment property (%s) has been deprecated. Please use the %s attribute to enable/disable per-deployment logging.")
    public void perDeploymentPropertyDeprecated(String var1, String var2);

    @Deprecated
    @LogMessage(level=Logger.Level.WARN)
    @Message(id=16, value="The per-logging deployment property (%s) is being ignored because the attribute %s has been set to ignore configuration files in the deployment %s.")
    public void perLoggingDeploymentIgnored(String var1, String var2, String var3);

    @Message(id=17, value="Could not access %s.")
    public String cannotAccessClass(@Cause Throwable var1, String var2);

    @Message(id=18, value="Failed to instantiate class '%s' for %s '%s'")
    public IllegalArgumentException cannotInstantiateClass(@Cause Throwable var1, String var2, String var3, String var4);

    @Message(id=19, value="Failed to load module '%s' for %s '%s'")
    public IllegalArgumentException cannotLoadModule(@Cause Throwable var1, String var2, String var3, String var4);

    @Message(id=20, value="Can not unassign handler. Handler %s is not assigned.")
    public String cannotUnassignHandler(String var1);

    @Message(id=21, value="Class '%s' could not be found.")
    public String classNotFound(@Cause Throwable var1, String var2);

    @Message(id=22, value="The encoding value '%s' is invalid.")
    public IllegalArgumentException failedToSetHandlerEncoding(@Cause Throwable var1, String var2);

    @Message(id=23, value="Handler %s is already assigned.")
    public String handlerAlreadyDefined(String var1);

    @Message(id=24, value="Handler %s not found.")
    public IllegalArgumentException handlerNotFound(String var1);

    @Message(id=25, value="Filter %s is invalid")
    public String invalidFilter(String var1);

    @Message(id=26, value="Log level %s is invalid.")
    public String invalidLogLevel(String var1);

    @Message(id=27, value="Overflow action %s is invalid.")
    public String invalidOverflowAction(String var1);

    @Message(id=28, value="Invalid size %s")
    public String invalidSize(String var1);

    @Message(id=29, value="Invalid value for target name. Valid names include: %s")
    public String invalidTargetName(EnumSet<Target> var1);

    @Message(id=31, value="Value type key '%s' is invalid. Valid value type keys are; %s")
    public String invalidValueTypeKey(String var1, Collection<String> var2);

    @Message(id=32, value="Missing required nested filter element")
    public String missingRequiredNestedFilterElement();

    @Message(id=34, value="Unknown parameter type (%s) for property '%s' on '%s'")
    public IllegalArgumentException unknownParameterType(Class<?> var1, String var2, Class<?> var3);

    @Message(id=35, value="Logger '%s' was not found.")
    public String loggerNotFound(String var1);

    @Message(id=39, value="An absolute path (%s) cannot be specified for relative-to.")
    public String invalidRelativeTo(String var1);

    @Message(id=40, value="An absolute path (%2$s) cannot be used when a relative-to path (%1$s) is being used.")
    public String invalidPath(String var1, String var2);

    @Message(id=41, value="The suffix (%s) is invalid. A suffix must be a valid date format.")
    public String invalidSuffix(String var1);

    @Message(id=42, value="Failed to configure logging using '%s' configuration file.")
    public DeploymentUnitProcessingException failedToConfigureLogging(@Cause Throwable var1, String var2);

    @Message(id=43, value="Error occurred while searching for logging configuration files.")
    public DeploymentUnitProcessingException errorProcessingLoggingConfiguration(@Cause Throwable var1);

    @Message(id=44, value="Handler %s is attached to the following handlers and cannot be removed; %s")
    public OperationFailedException handlerAttachedToHandlers(String var1, Collection<String> var2);

    @Message(id=45, value="Handler %s is attached to the following loggers and cannot be removed; %s")
    public OperationFailedException handlerAttachedToLoggers(String var1, Collection<String> var2);

    @Message(id=46, value="Cannot add handler (%s) to itself")
    public String cannotAddHandlerToSelf(String var1);

    @Message(id=47, value="The handler is closed, cannot publish to a closed handler")
    public IllegalStateException handlerClosed();

    @Message(id=-1, value="Cannot set property '%s' on a closed handler with value '%s'.")
    public IllegalStateException handlerClosed(String var1, String var2);

    @Message(id=48, value="Configuration for handler '%s' could not be found.")
    public String handlerConfigurationNotFound(String var1);

    @Message(id=49, value="Configuration for logger '%s' could not be found.")
    public String loggerConfigurationNotFound(String var1);

    @Message(id=50, value="Method %s on class %s is not supported")
    public UnsupportedOperationException unsupportedMethod(String var1, String var2);

    @Message(id=51, value="Failed to write configuration file %s")
    public RuntimeException failedToWriteConfigurationFile(@Cause Throwable var1, File var2);

    @Message(id=52, value="A failure was detecting while performing a rollback.")
    public RuntimeException rollbackFailure(@Cause Throwable var1);

    @Message(id=54, value="Failed to load class '%s' for %s '%s'")
    public IllegalArgumentException failedToLoadClass(@Cause Throwable var1, String var2, String var3, String var4);

    @Message(id=55, value="No property named '%s' for %s '%s' of type '%s'")
    public IllegalArgumentException invalidProperty(String var1, String var2, String var3, Class<?> var4);

    @Message(id=56, value="Failed to locate constructor in class \"%s\" for %s \"%s\"")
    public IllegalArgumentException failedToLocateConstructor(@Cause Throwable var1, String var2, String var3, String var4);

    @Message(id=57, value="Cannot set property '%s' on %s '%s' (removed)")
    public IllegalArgumentException cannotSetRemovedProperty(String var1, String var2, String var3);

    @Message(id=58, value="No property '%s' setter found for %s '%s'")
    public IllegalArgumentException propertySetterNotFound(String var1, String var2, String var3);

    @Message(id=59, value="No property '%s' type could be determined for %s '%s'")
    public IllegalArgumentException propertyTypeNotFound(String var1, String var2, String var3);

    @Message(id=60, value="Cannot remove property '%s' on %s '%s' (removed)")
    public IllegalArgumentException propertyAlreadyRemoved(String var1, String var2, String var3);

    @Message(id=61, value="Formatter '%s' is not found")
    public String formatterNotFound(String var1);

    @Message(id=62, value="Unsupported character set '%s'")
    public IllegalArgumentException unsupportedCharSet(String var1);

    @Message(id=63, value="Error manager '%s' is not found")
    public IllegalArgumentException errorManagerNotFound(String var1);

    @Message(id=64, value="Nested handlers not supported for handler %s")
    public IllegalArgumentException nestedHandlersNotSupported(Class<? extends Handler> var1);

    @Message(id=65, value="Logger '%s' already exists")
    public IllegalArgumentException loggerAlreadyExists(String var1);

    @Message(id=66, value="Formatter '%s' already exists")
    public IllegalArgumentException formatterAlreadyExists(String var1);

    @Message(id=67, value="Filter '%s' already exists")
    public IllegalArgumentException filterAlreadyExists(String var1);

    @Message(id=68, value="ErrorManager '%s' already exists")
    public IllegalArgumentException errorManagerAlreadyExists(String var1);

    @Message(id=69, value="Cannot assign null value to primitive property '%s' of %s")
    public IllegalArgumentException cannotAssignNullToPrimitive(String var1, Class<?> var2);

    @Message(id=70, value="Truncated filter expression string")
    public IllegalArgumentException truncatedFilterExpression();

    @Message(id=71, value="Invalid escape found in filter expression string")
    public IllegalArgumentException invalidEscapeFoundInFilterExpression();

    @Message(id=72, value="Filter '%s' is not found")
    public IllegalArgumentException filterNotFound(String var1);

    @Message(id=73, value="Expected identifier next in filter expression")
    public IllegalArgumentException expectedIdentifier();

    @Message(id=74, value="Expected string next in filter expression")
    public IllegalArgumentException expectedString();

    @Message(id=75, value="Expected '%s' next in filter expression")
    public IllegalArgumentException expected(String var1);

    @Message(id=-1, value="Expected '%s' or '%s' next in filter expression")
    public IllegalArgumentException expected(String var1, String var2);

    @Message(id=76, value="Unexpected end of filter expression")
    public IllegalArgumentException unexpectedEnd();

    @Message(id=77, value="Extra data after filter expression")
    public IllegalArgumentException extraData();

    @Message(id=78, value="The logging subsystem requires the log manager to be org.jboss.logmanager.LogManager. The subsystem has not be initialized and cannot be used. To use JBoss Log Manager you must add the system property \"java.util.logging.manager\" and set it to \"org.jboss.logmanager.LogManager\"")
    public IllegalStateException extensionNotInitialized();

    @Message(id=79, value="Failed to read the log file '%s'")
    public RuntimeException failedToReadLogFile(@Cause Throwable var1, String var2);

    @Message(id=80, value="File '%s' was not found and cannot be found in the %s directory.")
    public Resource.NoSuchResourceException logFileNotFound(String var1, String var2);

    @Message(id=81, value="File '%s' is not allowed to be read.")
    public OperationFailedException readNotAllowed(String var1);

    @Message(id=82, value="The suffix (%s) can not contain seconds or milliseconds.")
    public String suffixContainsMillis(String var1);

    @Message(id=83, value="Path '%s' is a directory and cannot be used as a log file.")
    public OperationFailedException invalidLogFile(String var1);

    @Message(id=84, value="Resources of type %s cannot be registered")
    public UnsupportedOperationException cannotRegisterResourceOfType(String var1);

    @Message(id=85, value="Resources of type %s cannot be removed")
    public UnsupportedOperationException cannotRemoveResourceOfType(String var1);

    @Message(id=86, value="Could not determine deployment name from the address %s.")
    public IllegalArgumentException deploymentNameNotFound(PathAddress var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=87, value="Failed to process logging directory %s. Log files cannot be listed.")
    public void errorProcessingLogDirectory(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=88, value="Could not determine %s had any children resources.")
    public void errorDeterminingChildrenExist(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=89, value="The log manager check was skipped and the log manager system property, \"java.util.logging.manager\", does not appear to be set to \"org.jboss.logmanager.LogManager\". The current value is \"%s\". Some behavior of the logged output such as MDC and NDC may not work as expected.")
    public void unknownLogManager(String var1);

    @Once
    @LogMessage(level=Logger.Level.WARN)
    @Message(id=90, value="The following path expressions could not be resolved while attempting to determine which log files are available to be read: %s")
    public void unresolvablePathExpressions(Set<String> var1);
}

