/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.wildfly.iiop.openjdk.IIOPRootDefinition;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;

public class ConfigValidator {
    private ConfigValidator() {
    }

    public static void validateConfig(OperationContext context, ModelNode resourceModel) throws OperationFailedException {
        boolean supportSSL = IIOPRootDefinition.SUPPORT_SSL.resolveModelAttribute(context, resourceModel).asBoolean();
        boolean serverRequiresSsl = IIOPRootDefinition.SERVER_REQUIRES_SSL.resolveModelAttribute(context, resourceModel).asBoolean();
        boolean clientRequiresSsl = IIOPRootDefinition.CLIENT_REQUIRES_SSL.resolveModelAttribute(context, resourceModel).asBoolean();
        ConfigValidator.validateSSLConfig(context, resourceModel, supportSSL, serverRequiresSsl, clientRequiresSsl);
        ConfigValidator.validateIORTransportConfig(context, resourceModel, supportSSL, serverRequiresSsl);
        ConfigValidator.validateORBInitializerConfig(context, resourceModel);
    }

    private static void validateSSLConfig(OperationContext context, ModelNode model, boolean supportSSL, boolean serverRequiresSsl, boolean clientRequiresSsl) throws OperationFailedException {
        if (supportSSL) {
            ModelNode securityDomainNode = IIOPRootDefinition.SECURITY_DOMAIN.resolveModelAttribute(context, model);
            ModelNode serverSSLContextNode = IIOPRootDefinition.SERVER_SSL_CONTEXT.resolveModelAttribute(context, model);
            ModelNode clientSSLContextNode = IIOPRootDefinition.CLIENT_SSL_CONTEXT.resolveModelAttribute(context, model);
            if (!(securityDomainNode.isDefined() || serverSSLContextNode.isDefined() && clientSSLContextNode.isDefined())) {
                throw IIOPLogger.ROOT_LOGGER.noSecurityDomainOrSSLContextsSpecified();
            }
        } else if (serverRequiresSsl || clientRequiresSsl) {
            throw IIOPLogger.ROOT_LOGGER.sslNotConfigured();
        }
    }

    private static void validateIORTransportConfig(OperationContext context, ModelNode resourceModel, boolean sslConfigured, boolean serverRequiresSsl) throws OperationFailedException {
        ConfigValidator.validateSSLAttribute(context, resourceModel, sslConfigured, serverRequiresSsl, IIOPRootDefinition.INTEGRITY);
        ConfigValidator.validateSSLAttribute(context, resourceModel, sslConfigured, serverRequiresSsl, IIOPRootDefinition.CONFIDENTIALITY);
        ConfigValidator.validateSSLAttribute(context, resourceModel, sslConfigured, serverRequiresSsl, IIOPRootDefinition.TRUST_IN_CLIENT);
        ConfigValidator.validateTrustInTarget(context, resourceModel, sslConfigured);
        ConfigValidator.validateSupportedAttribute(context, resourceModel, IIOPRootDefinition.DETECT_MISORDERING);
        ConfigValidator.validateSupportedAttribute(context, resourceModel, IIOPRootDefinition.DETECT_REPLAY);
    }

    private static void validateSSLAttribute(OperationContext context, ModelNode resourceModel, boolean sslConfigured, boolean serverRequiresSsl, AttributeDefinition attributeDefinition) throws OperationFailedException {
        ModelNode attributeNode = attributeDefinition.resolveModelAttribute(context, resourceModel);
        if (attributeNode.isDefined()) {
            String attribute = attributeNode.asString();
            if (sslConfigured) {
                if (attribute.equals("none")) {
                    throw IIOPLogger.ROOT_LOGGER.inconsistentSupportedTransportConfig(attributeDefinition.getName());
                }
                if (serverRequiresSsl && attribute.equals("supported")) {
                    throw IIOPLogger.ROOT_LOGGER.inconsistentRequiredTransportConfig("server-requires-ssl", attributeDefinition.getName());
                }
            } else if (!attribute.equals("none")) {
                throw IIOPLogger.ROOT_LOGGER.inconsistentUnsupportedTransportConfig(attributeDefinition.getName());
            }
        }
    }

    private static void validateTrustInTarget(OperationContext context, ModelNode resourceModel, boolean sslConfigured) throws OperationFailedException {
        ModelNode establishTrustInTargetNode = IIOPRootDefinition.TRUST_IN_TARGET.resolveModelAttribute(context, resourceModel);
        if (establishTrustInTargetNode.isDefined()) {
            String establishTrustInTarget = establishTrustInTargetNode.asString();
            if (sslConfigured && establishTrustInTarget.equals("none")) {
                throw IIOPLogger.ROOT_LOGGER.inconsistentSupportedTransportConfig("trust-in-target");
            }
        }
    }

    private static void validateSupportedAttribute(OperationContext context, ModelNode resourceModel, AttributeDefinition attributeDefinition) throws OperationFailedException {
        ModelNode attributeNode = attributeDefinition.resolveModelAttribute(context, resourceModel);
        if (attributeNode.isDefined() && !attributeNode.asString().equals("supported")) {
            throw IIOPLogger.ROOT_LOGGER.inconsistentSupportedTransportConfig(attributeDefinition.getName());
        }
    }

    private static void validateORBInitializerConfig(OperationContext context, ModelNode resourceModel) throws OperationFailedException {
        ModelNode securityInitializerNode = IIOPRootDefinition.SECURITY.resolveModelAttribute(context, resourceModel);
        ModelNode authContextNode = IIOPRootDefinition.AUTHENTICATION_CONTEXT.resolveModelAttribute(context, resourceModel);
        if (!(securityInitializerNode.isDefined() && securityInitializerNode.asString().equalsIgnoreCase("elytron") || !authContextNode.isDefined())) {
            throw IIOPLogger.ROOT_LOGGER.ineffectiveAuthenticationContextConfiguration();
        }
    }
}

