/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import org.jboss.logging.Cause;
import org.jboss.logging.Message;
import org.jboss.logging.MessageBundle;
import org.jboss.logging.Messages;
import org.picketlink.common.exceptions.NotImplementedException;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.credential.encoder.PasswordEncoder;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.spi.IdentityStore;

@MessageBundle(projectCode="PLIDM")
public interface IDMMessages {
    public static final IDMMessages MESSAGES = (IDMMessages)Messages.getBundle(IDMMessages.class);

    @Message(id=1, value="Error creating instance for type [%s].")
    public IdentityManagementException instantiationError(Class<?> var1, @Cause Throwable var2);

    @Message(id=2, value="Null argument: [%s].")
    public IdentityManagementException nullArgument(String var1);

    @Message(id=3, value="Error unmarshalling object.")
    public IdentityManagementException unmarshallingError(@Cause Throwable var1);

    @Message(id=4, value="Error marshalling object.")
    public IdentityManagementException marshallingError(@Cause Throwable var1);

    @Message(id=5, value="Unexpected type [%s].")
    public IdentityManagementException unexpectedType(Class<?> var1);

    @Message(id=6, value="Could not initialize Partition Manager [%s].")
    public IdentityManagementException partitionManagerInitializationFailed(Class<? extends PartitionManager> var1, @Cause Throwable var2);

    @Message(id=7, value="Not implemented.")
    public NotImplementedException notImplemented();

    @Message(id=200, value="Credential validation failed [%s].")
    public IdentityManagementException credentialValidationFailed(Credentials var1, @Cause Throwable var2);

    @Message(id=201, value="Credential update failed for account [%s] and type [%s].")
    public IdentityManagementException credentialUpdateFailed(Account var1, Object var2, @Cause Throwable var3);

    @Message(id=202, value="No IdentityStore found for credential class [%s]")
    public IdentityManagementException credentialNoStoreForCredentials(Class<?> var1);

    @Message(id=203, value="Credentials class [%s] not supported by this handler [%s].")
    public IdentityManagementException credentialUnsupportedType(Class<?> var1, CredentialHandler var2);

    @Message(id=204, value="Credentials could not be retrieved for account [%s] and storage [%s].")
    public <T extends CredentialStorage> IdentityManagementException credentialRetrievalFailed(Account var1, Class<T> var2, @Cause Throwable var3);

    @Message(id=205, value="The IdentityType returned is not an Account: [%s]")
    public IdentityManagementException credentialInvalidAccountType(Class<? extends IdentityType> var1);

    @Message(id=206, value="Multiple Account objects found with same login name [%s] for account type [%s].")
    public IdentityManagementException credentialMultipleAccountsFoundForType(String var1, Class<? extends Account> var2);

    @Message(id=207, value="No Account type provided. You must provide at least one Account type in order to support credential management.")
    public IdentityManagementException credentialNoAccountTypeProvided();

    @Message(id=208, value="Account type [%s] does not provide a property annotated with @StereotypeProperty(IDENTITY_USER_NAME). Without this the account can not be retrieved from the store based on the user name.")
    public IdentityManagementException credentialUnknownUserNameProperty(Class<? extends Account> var1);

    @Message(value="Invalid Realm or it was not provided.")
    public IdentityManagementException credentialDigestInvalidRealm();

    @Message(value="Invalid Password or it was not provided.")
    public IdentityManagementException credentialInvalidPassword();

    @Message(value="Could not encode password.")
    public IdentityManagementException credentialCouldNotEncodePassword(@Cause UnsupportedEncodingException var1);

    @Message(value="No suitable CredentialHandler available for validating Credentials of type [%s].")
    public IdentityManagementException credentialHandlerNotFoundForCredentialType(Class<?> var1);

    @Message(value="No such algorithm [%s] for encoding passwords. Using PasswordEncoder [%s].")
    public IdentityManagementException credentialInvalidEncodingAlgorithm(String var1, PasswordEncoder var2, @Cause Throwable var3);

    @Message(value="There is no Token.Consumer that supports this token [%s].")
    public IdentityManagementException credentialNoConsumerForToken(Token var1);

    @Message(id=700, value="Could not create configuration.")
    public SecurityConfigurationException configCouldNotCreateConfiguration(@Cause Exception var1);

    @Message(id=701, value="Invalid configuration [%s].")
    public SecurityConfigurationException configInvalidConfiguration(String var1, @Cause Throwable var2);

    @Message(id=702, value="You must provide at least one configuration.")
    public SecurityConfigurationException configNoConfigurationProvided();

    @Message(id=703, value="You have provided more than one configuration. Use the buildAll method instead.")
    public SecurityConfigurationException configBuildMultipleConfigurationExists();

    @Message(id=704, value="At least one IdentityConfiguration must be provided")
    public SecurityConfigurationException configNoIdentityConfigurationProvided();

    @Message(id=705, value="You must configure at least one identity store.")
    public SecurityConfigurationException configStoreNoIdentityStoreConfigProvided();

    @Message(id=706, value="Duplicated supported types [%s] found for identity store configuration. Check your identity store configuration for duplicated types, considering their hierarchy.")
    public SecurityConfigurationException configStoreDuplicatedSupportedType(Class<?> var1);

    @Message(id=707, value="Multiple configuration with credential support.")
    public SecurityConfigurationException configMultipleConfigurationsFoundWithCredentialSupport();

    @Message(value="Error initializing JpaIdentityStore - no entity classes configured.")
    public SecurityConfigurationException configJpaStoreNoEntityClassesProvided();

    @Message(value="Entity [%s] must have a field annotated with %s.")
    public SecurityConfigurationException configJpaStoreRequiredMappingAnnotation(Class<?> var1, Class<? extends Annotation> var2);

    @Message(value="Invalid mapping for type [%s]. No entity found with a field annotated with %s.")
    public SecurityConfigurationException configJpaStoreRequiredMappingAnnotationForAttributedType(Class<? extends AttributedType> var1, Class<? extends Annotation> var2);

    @Message(value="Attribute support is enabled (ad-hoc). But no entity was found with the necessary mapping to store attributes.")
    public SecurityConfigurationException configJpaStoreMappedNoAttributeMappingFound();

    @Message(value="Credential support is enabled. But no entity was found with the necessary mapping to store any CredentialStorage.")
    public SecurityConfigurationException configJpaStoreMappedNoCredentialStorageMappingFound();

    @Message(value="Mapped attribute [%s.%s] does not map to any field for type [%s].")
    public SecurityConfigurationException configJpaStoreMappedPropertyNotFound(Class<?> var1, String var2, Class<?> var3);

    @Message(value="Unknown IdentityStore class for configuration [%s].")
    public SecurityConfigurationException configUnknownStoreForConfiguration(IdentityStoreConfiguration var1);

    @Message(value="Error while creating IdentityStore [%s] instance for configuration [%s].")
    public SecurityConfigurationException configCouldNotCreateStore(Class<? extends IdentityStore> var1, IdentityStoreConfiguration var2, @Cause Exception var3);

    @Message(value="Only a single identity store config can support partitions. Found [%s] and [%s].")
    public SecurityConfigurationException configStoreMultiplePartitionConfigExists(IdentityStoreConfiguration var1, IdentityStoreConfiguration var2);

    @Message(value="Multiple configuration with the same name [%s].")
    public SecurityConfigurationException configMultipleConfigurationsFoundWithSameName(String var1);

    @Message(value="Could not grant permission to [%s] for resource [%s], operation [%s].")
    public IdentityManagementException permissionGrantFailed(IdentityType var1, Object var2, String var3, @Cause Throwable var4);

    @Message(value="Could not grant Permissions [%s].")
    public IdentityManagementException permissionsGrantFailed(String var1, @Cause Throwable var2);

    @Message(value="Could not revoke permission granted to [%s] for resource [%s], operation [%s].")
    public IdentityManagementException permissionRevokeFailed(IdentityType var1, Object var2, String var3, @Cause Throwable var4);

    @Message(value="Could not revoke Permissions [%s].")
    public IdentityManagementException permissionsRevokeFailed(String var1, @Cause Throwable var2);

    @Message(value="Failed to revoke all permissions for resource [%s].")
    public IdentityManagementException permissionRevokeAllFailed(Object var1, @Cause Throwable var2);
}

