/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.extension.messaging.activemq.BroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.BroadcastGroupControlHandler;
import org.wildfly.extension.messaging.activemq.BroadcastGroupRemove;
import org.wildfly.extension.messaging.activemq.BroadcastGroupWriteAttributeHandler;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class BroadcastGroupDefinition
extends PersistentResourceDefinition {
    public static final RuntimeCapability<Void> CHANNEL_FACTORY_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.messaging.activemq.broadcast-group.channel-factory", (boolean)true).build();
    public static final PrimitiveListAttributeDefinition CONNECTOR_REFS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("connectors").setAllowNull(true)).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setAttributeParser(AttributeParser.STRING_LIST)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setAllowExpression(false)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition BROADCAST_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"broadcast-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultBroadcastPeriod()))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition JGROUPS_STACK = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)CommonAttributes.JGROUPS_STACK).setCapabilityReference(JGroupsRequirement.CHANNEL_FACTORY.getName(), CHANNEL_FACTORY_CAPABILITY)).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{JGROUPS_STACK, CommonAttributes.JGROUPS_CHANNEL, CommonAttributes.SOCKET_BINDING, BROADCAST_PERIOD, CONNECTOR_REFS};
    public static final String GET_CONNECTOR_PAIRS_AS_JSON = "get-connector-pairs-as-json";
    static final BroadcastGroupDefinition INSTANCE = new BroadcastGroupDefinition();

    private BroadcastGroupDefinition() {
        super(MessagingExtension.BROADCAST_GROUP_PATH, MessagingExtension.getResourceDescriptionResolver("broadcast-group"), (OperationStepHandler)BroadcastGroupAdd.INSTANCE, (OperationStepHandler)BroadcastGroupRemove.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)BroadcastGroupWriteAttributeHandler.INSTANCE);
        }
        BroadcastGroupControlHandler.INSTANCE.registerAttributes(registry);
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        BroadcastGroupControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
        SimpleOperationDefinition op = new SimpleOperationDefinitionBuilder(GET_CONNECTOR_PAIRS_AS_JSON, this.getResourceDescriptionResolver()).withFlags(EnumSet.of(OperationEntry.Flag.READ_ONLY, OperationEntry.Flag.RUNTIME_ONLY)).setReplyType(ModelType.STRING).build();
        registry.registerOperationHandler((OperationDefinition)op, (OperationStepHandler)BroadcastGroupControlHandler.INSTANCE);
    }

    static void validateConnectors(OperationContext context, ModelNode operation, ModelNode connectorRefs) throws OperationFailedException {
        Set<String> availableConnectors = BroadcastGroupDefinition.getAvailableConnectors(context, operation);
        List operationAddress = operation.get("address").asList();
        String broadCastGroup = ((ModelNode)operationAddress.get(operationAddress.size() - 1)).get("broadcast-group").asString();
        for (ModelNode connectorRef : connectorRefs.asList()) {
            String connectorName = connectorRef.asString();
            if (availableConnectors.contains(connectorName)) continue;
            throw MessagingLogger.ROOT_LOGGER.wrongConnectorRefInBroadCastGroup(broadCastGroup, connectorName, availableConnectors);
        }
    }

    private static Set<String> getAvailableConnectors(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress active = MessagingServices.getActiveMQServerPathAddress(address);
        Resource activeMQServerResource = context.readResourceFromRoot(active);
        HashSet<String> availableConnectors = new HashSet<String>();
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("http-connector"));
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("in-vm-connector"));
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("remote-connector"));
        availableConnectors.addAll(activeMQServerResource.getChildrenNames("connector"));
        return availableConnectors;
    }

    public void registerCapabilities(ManagementResourceRegistration registration) {
        registration.registerCapability(CHANNEL_FACTORY_CAPABILITY);
    }
}

