/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttribute;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryType;
import org.wildfly.extension.messaging.activemq.jms.Validators;

public interface ConnectionFactoryAttributes {

    public static interface Pooled {
        public static final String USE_JNDI_PROP_NAME = "useJNDI";
        public static final String SETUP_ATTEMPTS_PROP_NAME = "setupAttempts";
        public static final String SETUP_INTERVAL_PROP_NAME = "setupInterval";
        public static final String REBALANCE_CONNECTIONS_PROP_NAME = "rebalanceConnections";
        public static final String RECONNECT_ATTEMPTS_PROP_NAME = "reconnectAttempts";
        public static final SimpleAttributeDefinition ENLISTMENT_TRACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"enlistment-trace", (ModelType)ModelType.BOOLEAN).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition INITIAL_CONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-connect-attempts", (ModelType)ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(1))).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition INITIAL_MESSAGE_PACKET_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-message-packet-size", (ModelType)ModelType.INT).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(1500))).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition JNDI_PARAMS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"jndi-params", (ModelType)ModelType.STRING).setAttributeGroup("inbound-config")).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition MANAGED_CONNECTION_POOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"managed-connection-pool", (ModelType)ModelType.STRING).setAllowExpression(true)).setAllowNull(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition MAX_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-pool-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(20))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition MIN_POOL_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"min-pool-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"password", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
        public static final SimpleAttributeDefinition REBALANCE_CONNECTIONS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"rebalance-connections", (ModelType)ModelType.BOOLEAN).setAllowNull(true)).setAllowExpression(true)).setDefaultValue(new ModelNode(false))).setAttributeGroup("inbound-config")).setRestartAllServices()).build();
        public static final AttributeDefinition RECONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(-1))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final SimpleAttributeDefinition SETUP_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"setup-attempts", (ModelType)ModelType.INT).setAttributeGroup("inbound-config")).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition SETUP_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"setup-interval", (ModelType)ModelType.LONG).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAttributeGroup("inbound-config")).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition TRANSACTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode().set("transaction"))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final AttributeDefinition USE_AUTO_RECOVERY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-auto-recovery", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(true))).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final AttributeDefinition USE_JNDI = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-jndi", (ModelType)ModelType.BOOLEAN).setAttributeGroup("inbound-config")).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final AttributeDefinition USE_LOCAL_TX = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-local-tx", (ModelType)ModelType.BOOLEAN).setAttributeGroup("inbound-config")).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final SimpleAttributeDefinition USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"user", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
        public static final SimpleAttributeDefinition STATISTICS_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"statistics-enabled", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode(false))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final ConnectionFactoryAttribute[] ATTRIBUTES = new ConnectionFactoryAttribute[]{ConnectionFactoryAttribute.create(USE_JNDI, "useJNDI", true, true), ConnectionFactoryAttribute.create((AttributeDefinition)JNDI_PARAMS, "jndiParams", true, true), ConnectionFactoryAttribute.create((AttributeDefinition)REBALANCE_CONNECTIONS, "rebalanceConnections", true, true), ConnectionFactoryAttribute.create(USE_LOCAL_TX, "useLocalTx", true, true), ConnectionFactoryAttribute.create((AttributeDefinition)SETUP_ATTEMPTS, "setupAttempts", true, true), ConnectionFactoryAttribute.create((AttributeDefinition)SETUP_INTERVAL, "setupInterval", true, true), ConnectionFactoryAttribute.create((AttributeDefinition)STATISTICS_ENABLED, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)TRANSACTION, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)USER, "userName", true), ConnectionFactoryAttribute.create((AttributeDefinition)PASSWORD, "password", true), ConnectionFactoryAttribute.create((AttributeDefinition)MANAGED_CONNECTION_POOL, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)ENLISTMENT_TRACE, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)MIN_POOL_SIZE, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)MAX_POOL_SIZE, null, false), ConnectionFactoryAttribute.create(USE_AUTO_RECOVERY, "useAutoRecovery", true), ConnectionFactoryAttribute.create((AttributeDefinition)INITIAL_MESSAGE_PACKET_SIZE, "initialMessagePacketSize", true), ConnectionFactoryAttribute.create((AttributeDefinition)INITIAL_CONNECT_ATTEMPTS, "initialConnectAttempts", true)};
    }

    public static interface Regular {
        public static final AttributeDefinition FACTORY_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"factory-type", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode().set(ConnectionFactoryType.GENERIC.toString()))).setValidator(ConnectionFactoryType.VALIDATOR)).setAllowNull(true)).setAllowExpression(true)).setRestartAllServices()).build();
        public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{FACTORY_TYPE};
        public static final AttributeDefinition INITIAL_MESSAGE_PACKET_SIZE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-message-packet-size", (ModelType)ModelType.INT).setStorageRuntime()).build();
    }

    public static interface Common {
        public static final AttributeDefinition AUTO_GROUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"auto-group", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition BLOCK_ON_ACKNOWLEDGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"block-on-acknowledge", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition BLOCK_ON_DURABLE_SEND = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"block-on-durable-send", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(true))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition BLOCK_ON_NON_DURABLE_SEND = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"block-on-non-durable-send", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition CACHE_LARGE_MESSAGE_CLIENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"cache-large-message-client", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition CLIENT_FAILURE_CHECK_PERIOD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"client-failure-check-period", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition COMPRESS_LARGE_MESSAGES = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"compress-large-messages", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition CONFIRMATION_WINDOW_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"confirmation-window-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(-1))).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition CONNECTION_LOAD_BALANCING_CLASS_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"connection-load-balancing-policy-class-name", (ModelType)ModelType.STRING).setDefaultValue(new ModelNode().set(ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME))).setAllowNull(true)).setAllowExpression(false)).build();
        public static final AttributeDefinition CONNECTION_TTL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("connection-ttl", ModelType.LONG).setDefaultValue(new ModelNode().set(ActiveMQClient.DEFAULT_CONNECTION_TTL))).setAllowNull(true)).setAllowExpression(true)).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).build();
        public static final StringListAttributeDefinition CONNECTORS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("connectors").setAlternatives(new String[]{"discovery-group"})).setRequired(true)).setAttributeParser(AttributeParser.STRING_LIST)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setRestartAllServices()).build();
        public static final AttributeDefinition CONSUMER_MAX_RATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"consumer-max-rate", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(-1))).setMeasurementUnit(MeasurementUnit.PER_SECOND)).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition CONSUMER_WINDOW_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"consumer-window-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0x100000))).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowNull(true)).setAllowExpression(true)).build();
        public static final SimpleAttributeDefinition DISCOVERY_GROUP = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"discovery-group", (ModelType)ModelType.STRING).setRequired(true)).setAlternatives(new String[]{"connectors"})).setRestartAllServices()).build();
        public static final AttributeDefinition DUPS_OK_BATCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"dups-ok-batch-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0x100000))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final StringListAttributeDefinition ENTRIES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("entries").setAllowNull(false)).setAllowExpression(true)).setListValidator((ParameterValidator)Validators.noDuplicateElements((ParameterValidator)new StringLengthValidator(1, false, true)))).setAttributeParser(AttributeParser.STRING_LIST)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setRestartAllServices()).build();
        public static final AttributeDefinition FAILOVER_ON_INITIAL_CONNECTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"failover-on-initial-connection", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition GROUP_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"group-id", (ModelType)ModelType.STRING).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition MAX_RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(ActiveMQClient.DEFAULT_MAX_RETRY_INTERVAL))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition MIN_LARGE_MESSAGE_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"min-large-message-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(102400))).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition PRE_ACKNOWLEDGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"pre-acknowledge", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(false))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition PRODUCER_MAX_RATE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"producer-max-rate", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(-1))).setMeasurementUnit(MeasurementUnit.PER_SECOND)).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition PRODUCER_WINDOW_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"producer-window-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(65536))).setMeasurementUnit(MeasurementUnit.BYTES)).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition PROTOCOL_MANAGER_FACTORY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"protocol-manager-factory", (ModelType)ModelType.STRING).setAllowNull(true)).build();
        public static final AttributeDefinition RECONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition RETRY_INTERVAL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"retry-interval", (ModelType)ModelType.LONG).setDefaultValue(new ModelNode().set(2000L))).setMeasurementUnit(MeasurementUnit.MILLISECONDS)).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition RETRY_INTERVAL_MULTIPLIER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"retry-interval-multiplier", (ModelType)ModelType.BIG_DECIMAL).setDefaultValue(new ModelNode().set(ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition SCHEDULED_THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"scheduled-thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultScheduledThreadPoolMaxSize()))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition THREAD_POOL_MAX_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"thread-pool-max-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultThreadPoolMaxSize()))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition TRANSACTION_BATCH_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"transaction-batch-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode().set(0x100000))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final AttributeDefinition USE_GLOBAL_POOLS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-global-pools", (ModelType)ModelType.BOOLEAN).setDefaultValue(new ModelNode().set(true))).setAllowNull(true)).setAllowExpression(true)).build();
        public static final ConnectionFactoryAttribute[] ATTRIBUTES = new ConnectionFactoryAttribute[]{ConnectionFactoryAttribute.create((AttributeDefinition)DISCOVERY_GROUP, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)CONNECTORS, null, false), ConnectionFactoryAttribute.create((AttributeDefinition)ENTRIES, "entries", true), ConnectionFactoryAttribute.create((AttributeDefinition)CommonAttributes.HA, "HA", true), ConnectionFactoryAttribute.create(CLIENT_FAILURE_CHECK_PERIOD, "clientFailureCheckPeriod", true), ConnectionFactoryAttribute.create(CONNECTION_TTL, "connectionTTL", true), ConnectionFactoryAttribute.create(CommonAttributes.CALL_TIMEOUT, "callTimeout", true), ConnectionFactoryAttribute.create((AttributeDefinition)CommonAttributes.CALL_FAILOVER_TIMEOUT, "callFailoverTimeout", true), ConnectionFactoryAttribute.create(CONSUMER_WINDOW_SIZE, "consumerWindowSize", true), ConnectionFactoryAttribute.create(CONSUMER_MAX_RATE, "consumerMaxRate", true), ConnectionFactoryAttribute.create(CONFIRMATION_WINDOW_SIZE, "confirmationWindowSize", true), ConnectionFactoryAttribute.create(PRODUCER_WINDOW_SIZE, "producerWindowSize", true), ConnectionFactoryAttribute.create(PRODUCER_MAX_RATE, "producerMaxRate", true), ConnectionFactoryAttribute.create(PROTOCOL_MANAGER_FACTORY, "protocolManagerFactoryStr", true), ConnectionFactoryAttribute.create(COMPRESS_LARGE_MESSAGES, "compressLargeMessage", true), ConnectionFactoryAttribute.create(CACHE_LARGE_MESSAGE_CLIENT, "cacheLargeMessagesClient", true), ConnectionFactoryAttribute.create(CommonAttributes.MIN_LARGE_MESSAGE_SIZE, "minLargeMessageSize", true), ConnectionFactoryAttribute.create((AttributeDefinition)CommonAttributes.CLIENT_ID, "clientID", true), ConnectionFactoryAttribute.create(DUPS_OK_BATCH_SIZE, "dupsOKBatchSize", true), ConnectionFactoryAttribute.create(TRANSACTION_BATCH_SIZE, "transactionBatchSize", true), ConnectionFactoryAttribute.create(BLOCK_ON_ACKNOWLEDGE, "blockOnAcknowledge", true), ConnectionFactoryAttribute.create(BLOCK_ON_NON_DURABLE_SEND, "blockOnNonDurableSend", true), ConnectionFactoryAttribute.create(BLOCK_ON_DURABLE_SEND, "blockOnDurableSend", true), ConnectionFactoryAttribute.create(AUTO_GROUP, "autoGroup", true), ConnectionFactoryAttribute.create(PRE_ACKNOWLEDGE, "preAcknowledge", true), ConnectionFactoryAttribute.create(RETRY_INTERVAL, "retryInterval", true), ConnectionFactoryAttribute.create(RETRY_INTERVAL_MULTIPLIER, "retryIntervalMultiplier", true), ConnectionFactoryAttribute.create(CommonAttributes.MAX_RETRY_INTERVAL, "maxRetryInterval", true), ConnectionFactoryAttribute.create(RECONNECT_ATTEMPTS, null, false), ConnectionFactoryAttribute.create(FAILOVER_ON_INITIAL_CONNECTION, "failoverOnInitialConnection", true), ConnectionFactoryAttribute.create(CONNECTION_LOAD_BALANCING_CLASS_NAME, "connectionLoadBalancingPolicyClassName", true), ConnectionFactoryAttribute.create(USE_GLOBAL_POOLS, "useGlobalPools", true), ConnectionFactoryAttribute.create(SCHEDULED_THREAD_POOL_MAX_SIZE, "scheduledThreadPoolMaxSize", true), ConnectionFactoryAttribute.create(THREAD_POOL_MAX_SIZE, "threadPoolMaxSize", true), ConnectionFactoryAttribute.create(GROUP_ID, "groupID", true)};
    }
}

