/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.ant;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.jboss.ws.api.tools.WSContractConsumer;
import org.jboss.ws.tools.ant.AntTaskHelper;
import org.jboss.ws.tools.ant.SecurityActions;
import org.jboss.ws.tools.cmd.WSConsume;

public class WSConsumeTask
extends Task {
    private CommandlineJava command = new CommandlineJava();
    private String wsdl;
    private File destdir;
    private File sourcedestdir;
    private List<File> bindingFiles = new ArrayList<File>();
    private File catalog;
    private File clientjar;
    private String wsdlLocation;
    private String encoding;
    private String targetPackage;
    private boolean keep;
    private boolean extension;
    private boolean verbose;
    private boolean fork;
    private boolean debug;
    private boolean nocompile;
    private boolean additionalHeaders;
    private String target;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Commandline.Argument createJvmarg() {
        return this.command.createVmArgument();
    }

    public void setBinding(File bindingFile) {
        this.bindingFiles.add(bindingFile);
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public void setClientJar(File clientJar) {
        this.clientjar = clientJar;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setAdditionalHeaders(boolean additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public void setSourcedestdir(File sourcedestdir) {
        this.sourcedestdir = sourcedestdir;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNoCompile(boolean nocompile) {
        this.nocompile = nocompile;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void addConfiguredBinding(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        File baseDir = ds.getBasedir();
        for (String file : ds.getIncludedFiles()) {
            this.bindingFiles.add(new File(baseDir, file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeNonForked() {
        ClassLoader prevCL = SecurityActions.getContextClassLoader();
        ClassLoader antLoader = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
        SecurityActions.setContextClassLoader(antLoader);
        PrintStream ps = null;
        try {
            WSContractConsumer consumer = WSContractConsumer.newInstance();
            consumer.setGenerateSource(this.keep);
            consumer.setExtension(this.extension);
            consumer.setAdditionalHeaders(this.additionalHeaders);
            consumer.setNoCompile(this.nocompile);
            if (this.destdir != null) {
                consumer.setOutputDirectory(this.destdir);
            }
            if (this.sourcedestdir != null) {
                consumer.setSourceDirectory(this.sourcedestdir);
            }
            if (this.targetPackage != null) {
                consumer.setTargetPackage(this.targetPackage);
            }
            if (this.wsdlLocation != null) {
                consumer.setWsdlLocation(this.wsdlLocation);
            }
            if (this.clientjar != null) {
                consumer.setClientJar(this.clientjar);
            }
            if (this.encoding != null) {
                consumer.setEncoding(this.encoding);
            }
            if (this.catalog != null) {
                if (this.catalog.exists() && this.catalog.isFile()) {
                    consumer.setCatalog(this.catalog);
                } else {
                    this.log("Catalog file not found: " + this.catalog, 1);
                }
            }
            if (this.bindingFiles != null && this.bindingFiles.size() > 0) {
                consumer.setBindingFiles(this.bindingFiles);
            }
            if (this.target != null) {
                consumer.setTarget(this.target);
            }
            this.log("Consuming wsdl: " + this.wsdl, 2);
            if (this.verbose) {
                ps = new PrintStream((OutputStream)new LogOutputStream((Task)this, 2));
                consumer.setMessageStream(ps);
            }
            try {
                consumer.setAdditionalCompilerClassPath(this.getTaskClassPathStrings());
                consumer.consume(this.wsdl);
            }
            catch (Throwable e) {
                throw new BuildException(e, this.getLocation());
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            SecurityActions.setContextClassLoader(prevCL);
        }
    }

    public void execute() throws BuildException {
        if (this.wsdl == null) {
            throw new BuildException("The wsdl attribute must be specified!", this.getLocation());
        }
        if (this.fork) {
            this.executeForked();
        } else {
            this.executeNonForked();
        }
    }

    private Path getTaskClassPath() {
        ClassLoader cl = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
        if (cl instanceof AntClassLoader) {
            return new Path(this.getProject(), ((AntClassLoader)cl).getClasspath());
        }
        return new Path(this.getProject());
    }

    private List<String> getTaskClassPathStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        ClassLoader cl = SecurityActions.getClassLoader(((Object)((Object)this)).getClass());
        if (cl instanceof AntClassLoader) {
            for (String string : ((AntClassLoader)cl).getClasspath().split(File.pathSeparator)) {
                strings.add(string);
            }
        }
        return strings;
    }

    private void executeForked() throws BuildException {
        this.command.setClassname(WSConsume.class.getName());
        Path path = this.command.createClasspath(this.getProject());
        path.append(this.getTaskClassPath());
        if (this.keep) {
            this.command.createArgument().setValue("-k");
        }
        if (this.extension) {
            this.command.createArgument().setValue("-e");
        }
        if (this.additionalHeaders) {
            this.command.createArgument().setValue("-a");
        }
        for (File file : this.bindingFiles) {
            this.command.createArgument().setValue("-b");
            this.command.createArgument().setFile(file);
        }
        if (this.catalog != null) {
            this.command.createArgument().setValue("-c");
            this.command.createArgument().setFile(this.catalog);
        }
        if (this.clientjar != null) {
            this.command.createArgument().setValue("-j");
            this.command.createArgument().setFile(this.clientjar);
        }
        if (this.targetPackage != null) {
            this.command.createArgument().setValue("-p");
            this.command.createArgument().setValue(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            this.command.createArgument().setValue("-w");
            this.command.createArgument().setValue(this.wsdlLocation);
        }
        if (this.encoding != null) {
            this.command.createArgument().setValue("--encoding");
            this.command.createArgument().setValue(this.encoding);
        }
        if (this.destdir != null) {
            this.command.createArgument().setValue("-o");
            this.command.createArgument().setFile(this.destdir);
        }
        if (this.sourcedestdir != null) {
            this.command.createArgument().setValue("-s");
            this.command.createArgument().setFile(this.sourcedestdir);
        }
        if (this.target != null) {
            this.command.createArgument().setValue("-t");
            this.command.createArgument().setValue(this.target);
        }
        if (this.verbose) {
            this.command.createArgument().setValue("-v");
        }
        this.command.createArgument().setValue(this.wsdl);
        this.log("Consuming wsdl: " + this.wsdl, 2);
        if (this.verbose) {
            this.log("Command invoked: " + this.command.getJavaCommand().toString());
        }
        ExecuteJava execute = new ExecuteJava();
        execute.setClasspath(path);
        execute.setJavaCommand(this.command.getJavaCommand());
        String[] arguments = this.command.getVmCommand().getArguments();
        CommandlineJava.SysProperties properties = AntTaskHelper.toSystemProperties(arguments);
        execute.setSystemProperties(properties);
        if (execute.fork((ProjectComponent)this) != 0) {
            throw new BuildException("Could not invoke WSConsumeTask", this.getLocation());
        }
    }
}

