/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceImpl;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ResourceManager;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHandlerImpl
extends ResourceHandler {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    ResourceManager manager;
    List<Pattern> excludePatterns;
    private long creationTime = System.currentTimeMillis();
    private long maxAge;
    private WebConfiguration webconfig = WebConfiguration.getInstance();

    public ResourceHandlerImpl() {
        ExternalContext extContext = FacesContext.getCurrentInstance().getExternalContext();
        this.manager = ApplicationAssociate.getInstance(extContext).getResourceManager();
        this.initExclusions(extContext.getApplicationMap());
        this.initMaxAge();
    }

    public Resource createResource(String resourceName) {
        Util.notNull("resourceName", resourceName);
        return this.createResource(resourceName, null, null);
    }

    public Resource createViewResource(FacesContext facesContext, String resourceName) {
        Util.notNull("resourceName", resourceName);
        boolean development = facesContext.isProjectStage(ProjectStage.Development);
        String ctype = this.getContentType(facesContext, resourceName);
        ResourceInfo info = this.manager.findResource(null, resourceName, ctype, true, facesContext);
        if (info == null) {
            if (!development && "application/x-groovy".equals(ctype)) {
                return null;
            }
            this.logMissingResource(facesContext, resourceName, null, null);
            return null;
        }
        return new ResourceImpl(info, ctype, this.creationTime, this.maxAge);
    }

    public Resource createResourceFromId(String resourceId) {
        Util.notNull("resourceId", resourceId);
        FacesContext ctx = FacesContext.getCurrentInstance();
        boolean development = ctx.isProjectStage(ProjectStage.Development);
        ResourceInfo info = this.manager.findResource(resourceId);
        String ctype = this.getContentType(ctx, resourceId);
        if (info == null) {
            if (!development && "application/x-groovy".equals(ctype)) {
                return null;
            }
            this.logMissingResource(ctx, resourceId, null);
            return null;
        }
        return new ResourceImpl(info, ctype, this.creationTime, this.maxAge);
    }

    public Resource createResource(String resourceName, String libraryName) {
        Util.notNull("resourceName", resourceName);
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Util.notNull("resourceName", resourceName);
        FacesContext ctx = FacesContext.getCurrentInstance();
        boolean development = ctx.isProjectStage(ProjectStage.Development);
        String ctype = contentType != null ? contentType : this.getContentType(ctx, resourceName);
        ResourceInfo info = this.manager.findResource(libraryName, resourceName, ctype, ctx);
        if (info == null) {
            if (!development && "application/x-groovy".equals(ctype)) {
                return null;
            }
            this.logMissingResource(ctx, resourceName, libraryName, null);
            return null;
        }
        return new ResourceImpl(info, ctype, this.creationTime, this.maxAge);
    }

    public boolean libraryExists(String libraryName) {
        if (libraryName.contains("../")) {
            return false;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        LibraryInfo info = this.manager.findLibrary(libraryName, null, null, context);
        if (null == info) {
            info = this.manager.findLibraryOnClasspathWithZipDirectoryEntryScan(libraryName, null, null, context, true);
        }
        return info != null;
    }

    public boolean isResourceRequest(FacesContext context) {
        Boolean isResourceRequest = (Boolean)RequestStateManager.get(context, "com.sun.faces.RESOURCE_REQUEST");
        if (isResourceRequest == null) {
            String resourceId = this.normalizeResourceRequest(context);
            isResourceRequest = resourceId != null ? resourceId.startsWith("/javax.faces.resource") : Boolean.FALSE.booleanValue();
            RequestStateManager.set(context, "com.sun.faces.RESOURCE_REQUEST", isResourceRequest);
        }
        return isResourceRequest;
    }

    public String getRendererTypeForResourceName(String resourceName) {
        String rendererType = null;
        String contentType = this.getContentType(FacesContext.getCurrentInstance(), resourceName);
        if (null != contentType) {
            if (-1 != (contentType = contentType.toLowerCase()).indexOf("javascript")) {
                rendererType = "javax.faces.resource.Script";
            } else if (-1 != contentType.indexOf("css")) {
                rendererType = "javax.faces.resource.Stylesheet";
            }
        }
        return rendererType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleResourceRequest(FacesContext context) throws IOException {
        String resourceId = this.normalizeResourceRequest(context);
        if (resourceId == null) {
            return;
        }
        ExternalContext extContext = context.getExternalContext();
        if (this.isExcluded(resourceId)) {
            extContext.setResponseStatus(404);
            return;
        }
        assert (null != resourceId);
        assert (resourceId.startsWith("/javax.faces.resource"));
        Resource resource = null;
        String resourceName = null;
        String libraryName = null;
        if ("/javax.faces.resource".length() < resourceId.length()) {
            boolean createResource;
            resourceName = resourceId.substring("/javax.faces.resource".length() + 1);
            assert (resourceName != null);
            libraryName = (String)context.getExternalContext().getRequestParameterMap().get("ln");
            if (libraryName != null) {
                createResource = this.libraryNameIsSafe(libraryName);
                if (!createResource) {
                    this.send404(context, resourceName, libraryName, true);
                    return;
                }
            } else {
                createResource = true;
            }
            if (createResource) {
                resource = context.getApplication().getResourceHandler().createResource(resourceName, libraryName);
            }
        }
        if (resource != null) {
            if (resource.userAgentNeedsUpdate(context)) {
                Channel resourceChannel = null;
                Channel out = null;
                ByteBuffer buf = this.allocateByteBuffer();
                try {
                    InputStream in = resource.getInputStream();
                    if (in == null) {
                        this.send404(context, resourceName, libraryName, true);
                        return;
                    }
                    resourceChannel = Channels.newChannel(in);
                    out = Channels.newChannel(extContext.getResponseOutputStream());
                    extContext.setResponseBufferSize(buf.capacity());
                    String contentType = resource.getContentType();
                    if (contentType != null) {
                        extContext.setResponseContentType(resource.getContentType());
                    }
                    this.handleHeaders(context, resource);
                    int size = 0;
                    int thisRead = resourceChannel.read(buf);
                    int totalWritten = 0;
                    while (thisRead != -1) {
                        buf.rewind();
                        buf.limit(thisRead);
                        while ((totalWritten += out.write(buf)) < size) {
                        }
                        buf.clear();
                        size += thisRead;
                        thisRead = resourceChannel.read(buf);
                    }
                    if (extContext.isResponseCommitted()) return;
                    extContext.setResponseContentLength(size);
                    return;
                }
                catch (IOException ioe) {
                    this.send404(context, resourceName, libraryName, ioe, true);
                    return;
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ignored) {}
                    }
                    if (resourceChannel != null) {
                        resourceChannel.close();
                    }
                }
            }
            this.send304(context);
            return;
        }
        this.send404(context, resourceName, libraryName, false);
    }

    private boolean libraryNameIsSafe(String libraryName) {
        assert (null != libraryName);
        boolean result = !libraryName.startsWith(".") && !libraryName.startsWith("/") && !libraryName.contains("/") && !libraryName.startsWith("\\") && !libraryName.contains("\\") && !libraryName.startsWith("%2e") && !libraryName.startsWith("%2f") && !libraryName.contains("%2f") && !libraryName.startsWith("%5c") && !libraryName.contains("%5c") && !libraryName.startsWith("\\u002e") && !libraryName.startsWith("\\u002f") && !libraryName.contains("\\u002f") && !libraryName.startsWith("\\u005c") && !libraryName.contains("\\u005c");
        return result;
    }

    private void send404(FacesContext ctx, String resourceName, String libraryName, boolean logMessage) {
        this.send404(ctx, resourceName, libraryName, null, logMessage);
    }

    private void send404(FacesContext ctx, String resourceName, String libraryName, Throwable t, boolean logMessage) {
        ctx.getExternalContext().setResponseStatus(404);
        if (logMessage) {
            this.logMissingResource(ctx, resourceName, libraryName, t);
        }
    }

    private void send304(FacesContext ctx) {
        ctx.getExternalContext().setResponseStatus(304);
    }

    long getCreationTime() {
        return this.creationTime;
    }

    void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    WebConfiguration getWebConfig() {
        return this.webconfig;
    }

    private void logMissingResource(FacesContext ctx, String resourceName, String libraryName, Throwable t) {
        Level level;
        if (!ctx.isProjectStage(ProjectStage.Production)) {
            level = Level.WARNING;
        } else {
            Level level2 = level = t != null ? Level.WARNING : Level.FINE;
        }
        if (libraryName != null) {
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, "jsf.application.resource.unable_to_serve_from_library", new Object[]{resourceName, libraryName});
                if (t != null) {
                    LOGGER.log(level, "", t);
                }
            }
        } else if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "jsf.application.resource.unable_to_serve", new Object[]{resourceName});
            if (t != null) {
                LOGGER.log(level, "", t);
            }
        }
    }

    private void logMissingResource(FacesContext ctx, String resourceId, Throwable t) {
        Level level;
        if (!ctx.isProjectStage(ProjectStage.Production)) {
            level = Level.WARNING;
        } else {
            Level level2 = level = t != null ? Level.WARNING : Level.FINE;
        }
        if (LOGGER.isLoggable(level)) {
            LOGGER.log(level, "jsf.application.resource.unable_to_serve", new Object[]{resourceId});
            if (t != null) {
                LOGGER.log(level, "", t);
            }
        }
    }

    private String getContentType(FacesContext ctx, String resourceName) {
        return ctx.getExternalContext().getMimeType(resourceName);
    }

    private String normalizeResourceRequest(FacesContext context) {
        String path;
        String facesServletMapping = Util.getFacesMapping(context);
        if (!Util.isPrefixMapped(facesServletMapping)) {
            path = context.getExternalContext().getRequestServletPath();
            int i = path.lastIndexOf(".");
            if (0 < i) {
                path = path.substring(0, i);
            }
        } else {
            path = context.getExternalContext().getRequestPathInfo();
        }
        return path;
    }

    private boolean isExcluded(String resourceId) {
        for (Pattern pattern : this.excludePatterns) {
            if (!pattern.matcher(resourceId).matches()) continue;
            return true;
        }
        return false;
    }

    private void initExclusions(Map<String, Object> appMap) {
        String excludesParam = this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceExcludes);
        String[] patterns = Util.split(appMap, excludesParam, " ");
        this.excludePatterns = new ArrayList<Pattern>(patterns.length);
        for (String pattern : patterns) {
            this.excludePatterns.add(Pattern.compile(".*\\" + pattern));
        }
    }

    private void initMaxAge() {
        this.maxAge = Long.parseLong(this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.DefaultResourceMaxAge));
    }

    private void handleHeaders(FacesContext ctx, Resource resource) {
        ExternalContext extContext = ctx.getExternalContext();
        for (Map.Entry cur : resource.getResponseHeaders().entrySet()) {
            extContext.setResponseHeader((String)cur.getKey(), (String)cur.getValue());
        }
    }

    private ByteBuffer allocateByteBuffer() {
        int size;
        try {
            size = Integer.parseInt(this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceBufferSize));
        }
        catch (NumberFormatException nfe) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.application.resource.invalid_resource_buffer_size", new Object[]{this.webconfig.getOptionValue(WebConfiguration.WebContextInitParameter.ResourceBufferSize), WebConfiguration.WebContextInitParameter.ResourceBufferSize.getQualifiedName(), WebConfiguration.WebContextInitParameter.ResourceBufferSize.getDefaultValue()});
            }
            size = Integer.parseInt(WebConfiguration.WebContextInitParameter.ResourceBufferSize.getDefaultValue());
        }
        return ByteBuffer.allocate(size);
    }
}

