/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.naming.client.remote;

import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.common.expression.Expression;
import org.wildfly.naming.client.NamingProviderFactory;
import org.wildfly.naming.client._private.Messages;
import org.wildfly.naming.client.remote.AggregateRemoteNamingProvider;
import org.wildfly.naming.client.remote.RemoteNamingProvider;
import org.wildfly.naming.client.remote.SingleRemoteNamingProvider;
import org.wildfly.naming.client.util.FastHashtable;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.util.CodePointIterator;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public final class RemoteNamingProviderFactory
implements NamingProviderFactory {
    public static final String USE_SEPARATE_CONNECTION = "org.wildfly.naming.client.remote.use-separate-connection";
    private static final String CONNECT_OPTIONS_PREFIX = "jboss.naming.client.connect.options.";
    private static final String NAMING_CLIENT_PREFIX = "jboss.naming.client.";
    private static final OptionMap DEFAULT_CONNECTION_CREATION_OPTIONS = OptionMap.create((Option)Options.SASL_POLICY_NOANONYMOUS, (Object)false);
    private static final String[] NO_STRINGS = new String[0];
    static final Attachments.Key<RemoteNamingProvider> PROVIDER_KEY = new Attachments.Key(RemoteNamingProvider.class);
    private static final AuthenticationContextConfigurationClient AUTH_CONFIGURATION_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);

    @Override
    public boolean supportsUriScheme(String providerScheme, FastHashtable<String, Object> env) {
        Endpoint endpoint = this.getEndpoint(env);
        return endpoint != null && endpoint.isValidUriScheme(providerScheme);
    }

    @Override
    public RemoteNamingProvider createProvider(FastHashtable<String, Object> env, URI ... providerUris) throws NamingException {
        ArrayList<RemoteNamingProvider> remoteNamingProviders = new ArrayList<RemoteNamingProvider>(providerUris.length);
        ClassLoader classLoader = RemoteNamingProviderFactory.secureGetContextClassLoader();
        Properties properties = RemoteNamingProviderFactory.getPropertiesFromEnv(env);
        Endpoint endpoint = this.getEndpoint(env);
        String callbackClass = RemoteNamingProviderFactory.getProperty(properties, "jboss.naming.client.security.callback.handler.class", null, true);
        String userName = RemoteNamingProviderFactory.getProperty(properties, "java.naming.security.principal", null, true);
        String password = RemoteNamingProviderFactory.getProperty(properties, "java.naming.security.credentials", null, false);
        String passwordBase64 = RemoteNamingProviderFactory.getProperty(properties, "jboss.naming.client.security.password.base64", null, false);
        String realm = RemoteNamingProviderFactory.getProperty(properties, "jboss.naming.client.security.realm", null, true);
        OptionMap configuredConnectOptions = RemoteNamingProviderFactory.getOptionMapFromProperties(properties, CONNECT_OPTIONS_PREFIX, classLoader);
        OptionMap connectOptions = RemoteNamingProviderFactory.mergeWithDefaultOptionMap(DEFAULT_CONNECTION_CREATION_OPTIONS, configuredConnectOptions);
        boolean useSeparateConnection = RemoteNamingProviderFactory.getBooleanValueFromProperties(properties, USE_SEPARATE_CONNECTION, false);
        CallbackHandler callbackHandler = null;
        String decodedPassword = null;
        if (callbackClass != null && (userName != null || password != null)) {
            throw Messages.log.callbackHandlerAndUsernameAndPasswordSpecified();
        }
        if (callbackClass != null) {
            try {
                Class<?> clazz = Class.forName(callbackClass, true, classLoader);
                callbackHandler = (CallbackHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw Messages.log.failedToLoadCallbackHandlerClass(e, callbackClass);
            }
            catch (Exception e) {
                throw Messages.log.failedToInstantiateCallbackHandlerInstance(e, callbackClass);
            }
        } else if (userName != null) {
            if (password != null && passwordBase64 != null) {
                throw Messages.log.plainTextAndBase64PasswordSpecified();
            }
            decodedPassword = passwordBase64 != null ? CodePointIterator.ofString((String)passwordBase64).base64Decode().asUtf8String().drainToString() : password;
        }
        AuthenticationContext captured = AuthenticationContext.captureCurrent();
        AuthenticationContextConfigurationClient client = AUTH_CONFIGURATION_CLIENT;
        for (URI providerUri : providerUris) {
            SSLContext sslContext;
            AuthenticationConfiguration operateConfiguration = client.getAuthenticationConfiguration(providerUri, captured, -1, "jndi", "jboss", useSeparateConnection ? null : "operate");
            try {
                sslContext = client.getSSLContext(providerUri, captured, "jndi", "jboss", "connect");
            }
            catch (GeneralSecurityException e) {
                throw Messages.log.failedToConfigureSslContext(e);
            }
            operateConfiguration = RemotingOptions.mergeOptionsIntoAuthenticationConfiguration((OptionMap)connectOptions, (AuthenticationConfiguration)operateConfiguration);
            if (callbackHandler != null) {
                operateConfiguration = operateConfiguration.useCallbackHandler(callbackHandler);
            } else if (userName != null) {
                operateConfiguration = operateConfiguration.useName(userName).usePassword(decodedPassword).useRealm(realm);
            }
            AuthenticationConfiguration connectConfiguration = useSeparateConnection ? operateConfiguration : client.getAuthenticationConfiguration(providerUri, captured, -1, "jndi", "jboss", "connect");
            remoteNamingProviders.add(new SingleRemoteNamingProvider(endpoint, providerUri, connectConfiguration, operateConfiguration, sslContext, env));
        }
        return new AggregateRemoteNamingProvider(remoteNamingProviders);
    }

    private Endpoint getEndpoint(FastHashtable<String, Object> env) {
        return env.containsKey("jboss.naming.client.endpoint") ? (Endpoint)env.get("jboss.naming.client.endpoint") : Endpoint.getCurrent();
    }

    private static Properties getPropertiesFromEnv(FastHashtable<String, Object> env) {
        Properties properties = new Properties();
        for (Map.Entry<String, Object> entry : env.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            properties.setProperty(RemoteNamingProviderFactory.processPropertyName(entry.getKey()), (String)entry.getValue());
        }
        return properties;
    }

    private static String getProperty(Properties properties, String propertyName, String defaultValue, boolean expand) {
        String str = properties.getProperty(propertyName);
        if (str == null) {
            return defaultValue;
        }
        if (expand) {
            Expression expression = Expression.compile((String)str, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX});
            return expression.evaluateWithPropertiesAndEnvironment(false);
        }
        return str.trim();
    }

    private static boolean getBooleanValueFromProperties(Properties properties, String propertyName, boolean defVal) {
        String str = RemoteNamingProviderFactory.getProperty(properties, propertyName, null, true);
        if (str == null) {
            return defVal;
        }
        return Boolean.parseBoolean(str);
    }

    private static OptionMap getOptionMapFromProperties(Properties properties, String propertyPrefix, ClassLoader classLoader) {
        return OptionMap.builder().parseAll(properties, propertyPrefix, classLoader).getMap();
    }

    private static String processPropertyName(String propertyName) {
        if (propertyName.startsWith("remote.connection.")) {
            if (propertyName.endsWith("callback.handler.class")) {
                propertyName = "jboss.naming.client.security.callback.handler.class";
            } else if (propertyName.endsWith("username")) {
                propertyName = "java.naming.security.principal";
            } else if (propertyName.endsWith("password")) {
                propertyName = "java.naming.security.credentials";
            } else if (propertyName.endsWith("password.base64")) {
                propertyName = "jboss.naming.client.security.password.base64";
            } else if (propertyName.contains("connect.options.")) {
                propertyName = NAMING_CLIENT_PREFIX + propertyName.substring(propertyName.indexOf("connect.options."));
            }
        }
        return propertyName;
    }

    private static OptionMap mergeWithDefaultOptionMap(OptionMap defaultOptions, OptionMap configuredOptions) {
        OptionMap.Builder mergedOptionMapBuilder = OptionMap.builder().addAll(configuredOptions);
        for (Option defaultOption : defaultOptions) {
            if (mergedOptionMapBuilder.getMap().contains(defaultOption)) continue;
            mergedOptionMapBuilder.set(defaultOption, defaultOptions.get(defaultOption));
        }
        return mergedOptionMapBuilder.getMap();
    }

    private static ClassLoader secureGetContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader contextClassLoader = sm != null ? AccessController.doPrivileged(RemoteNamingProviderFactory::getContextClassLoader) : RemoteNamingProviderFactory.getContextClassLoader();
        return contextClassLoader;
    }

    private static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

