/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedTask;
import javax.enterprise.concurrent.ManagedTaskListener;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;

class SecurityIdentityUtils {
    private SecurityIdentityUtils() {
    }

    static <T> Callable<T> doIdentityWrap(Callable<T> callable) {
        if (callable == null) {
            return null;
        }
        SecurityIdentity securityIdentity = SecurityIdentityUtils.getSecurityIdentity();
        if (securityIdentity == null) {
            return callable;
        }
        SecuredManagedCallable securedCallable = () -> securityIdentity.runAs(callable);
        return callable instanceof ManagedTask ? new SecuredManagedCallable(securedCallable, (ManagedTask)callable) : securedCallable;
    }

    static Runnable doIdentityWrap(Runnable runnable) {
        if (runnable == null) {
            return null;
        }
        SecurityIdentity securityIdentity = SecurityIdentityUtils.getSecurityIdentity();
        if (securityIdentity == null) {
            return runnable;
        }
        Runnable securedRunnable = () -> securityIdentity.runAs(runnable);
        return runnable instanceof ManagedTask ? new SecuredManagedRunnable(securedRunnable, (ManagedTask)runnable) : securedRunnable;
    }

    private static SecurityIdentity getSecurityIdentity() {
        SecurityDomain securityDomain = SecurityDomain.getCurrent();
        return securityDomain != null ? securityDomain.getCurrentSecurityIdentity() : null;
    }

    static class SecuredManagedTaskListener
    implements ManagedTaskListener {
        private final ManagedTaskListener managedTaskListener;

        SecuredManagedTaskListener(ManagedTaskListener managedTaskListener) {
            this.managedTaskListener = managedTaskListener;
        }

        public void taskAborted(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
            this.managedTaskListener.taskAborted(future, executor, (Object)((SecuredManagedTask)task).managedTask, exception);
        }

        public void taskDone(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
            this.managedTaskListener.taskDone(future, executor, (Object)((SecuredManagedTask)task).managedTask, exception);
        }

        public void taskStarting(Future<?> future, ManagedExecutorService executor, Object task) {
            this.managedTaskListener.taskStarting(future, executor, (Object)((SecuredManagedTask)task).managedTask);
        }

        public void taskSubmitted(Future<?> future, ManagedExecutorService executor, Object task) {
            this.managedTaskListener.taskSubmitted(future, executor, (Object)((SecuredManagedTask)task).managedTask);
        }
    }

    static class SecuredManagedCallable<T>
    extends SecuredManagedTask
    implements Callable<T> {
        private final Callable<T> runnable;

        SecuredManagedCallable(Callable<T> SecuredTask, ManagedTask managedTask) {
            super(managedTask);
            this.runnable = SecuredTask;
        }

        @Override
        public T call() throws Exception {
            return this.runnable.call();
        }
    }

    static class SecuredManagedRunnable
    extends SecuredManagedTask
    implements Runnable {
        private final Runnable runnable;

        SecuredManagedRunnable(Runnable SecuredTask, ManagedTask managedTask) {
            super(managedTask);
            this.runnable = SecuredTask;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }

    static class SecuredManagedTask
    implements ManagedTask {
        private final ManagedTask managedTask;
        private final SecuredManagedTaskListener managedTaskListenerWrapper;

        SecuredManagedTask(ManagedTask managedTask) {
            this.managedTask = managedTask;
            this.managedTaskListenerWrapper = managedTask.getManagedTaskListener() != null ? new SecuredManagedTaskListener(managedTask.getManagedTaskListener()) : null;
        }

        public Map<String, String> getExecutionProperties() {
            return this.managedTask.getExecutionProperties();
        }

        public ManagedTaskListener getManagedTaskListener() {
            return this.managedTaskListenerWrapper;
        }
    }
}

