/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.BlockingTimeout;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.host.controller.ServerInventory;
import org.jboss.as.host.controller.descriptions.HostResolver;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.dmr.ModelNode;

public class ServerResumeHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "resume";
    public static final OperationDefinition DEFINITION = ServerResumeHandler.getOperationDefinition();
    private final ServerInventory serverInventory;

    public ServerResumeHandler(ServerInventory serverInventory) {
        this.serverInventory = serverInventory;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
            throw new OperationFailedException(HostControllerLogger.ROOT_LOGGER.cannotStartServersInvalidMode(context.getRunningMode()));
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement element = address.getLastElement();
        final String serverName = element.getValue();
        final BlockingTimeout blockingTimeout = BlockingTimeout.Factory.getProxyBlockingTimeout((OperationContext)context);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                context.getServiceRegistry(true);
                List<ModelNode> errorResponses = ServerResumeHandler.this.serverInventory.resumeServers(Collections.singleton(serverName), blockingTimeout);
                if (!errorResponses.isEmpty()) {
                    context.getFailureDescription().set(errorResponses.get(0));
                }
            }
        }, OperationContext.Stage.RUNTIME);
    }

    static OperationDefinition getOperationDefinition() {
        return new SimpleOperationDefinitionBuilder(OPERATION_NAME, HostResolver.getResolver("host.server")).setRuntimeOnly().withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).build();
    }
}

