/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.logging;

import java.io.File;
import java.net.URL;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.vfs.VirtualFile;

@MessageLogger(projectCode="WFLYAC", length=4)
public interface AppClientLogger
extends BasicLogger {
    public static final AppClientLogger ROOT_LOGGER = (AppClientLogger)Logger.getMessageLogger(AppClientLogger.class, (String)"org.jboss.as.appclient");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=1, value="%s")
    public void caughtException(@Cause Throwable var1, Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=2, value="%s running app client main")
    public void exceptionRunningAppClient(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="Error closing connection")
    public void exceptionClosingConnection(@Cause Throwable var1);

    @Message(id=0, value="Name of the app client configuration file to use (default is \"appclient.xml\")")
    public String argAppClientConfig();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="Set the url of the application server instance to connect to")
    public String argHost();

    @Message(id=0, value="Load ejb-client.properties file from the given url")
    public String argConnectionProperties();

    @Message(id=0, value="Load system properties from the given url")
    public String argProperties();

    @Message(id=0, value="Set a system property")
    public String argSystemProperty();

    @Message(id=0, value="Usage: ./appclient.sh [args...] myear.ear#appClient.jar [client args...]%n%nwhere args include:%n")
    public String argUsage();

    @Message(id=0, value="Print version and exit")
    public String argVersion();

    @Message(id=0, value="Runs the container with the security manager enabled.")
    public String argSecMgr();

    @Message(id=0, value="The appclient script starts an application client which can be used to test and access the deployed EJBs.")
    public String usageDescription();

    @Message(id=4, value="You must specify the application client to execute")
    public String appClientNotSpecified();

    @Message(id=5, value="Argument expected for option %s")
    public String argumentExpected(String var1);

    @Message(id=6, value="Could not find application client jar in deployment")
    public RuntimeException cannotFindAppClient();

    @Message(id=7, value="Could not find application client %s")
    public DeploymentUnitProcessingException cannotFindAppClient(String var1);

    @Message(id=8, value="Could not load application client main class")
    public RuntimeException cannotLoadAppClientMainClass(@Cause Throwable var1);

    @Message(id=9, value="Could not load component class")
    public DeploymentUnitProcessingException cannotLoadComponentClass(@Cause Throwable var1);

    @Message(id=10, value="Unable to load properties from URL %s")
    public String cannotLoadProperties(URL var1);

    @Message(id=11, value="Could not start app client %s as no main class was found")
    public RuntimeException cannotStartAppClient(String var1);

    @Message(id=12, value="Could not start app client %s as no main method was found on main class %s")
    public RuntimeException cannotStartAppClient(String var1, Class<?> var2);

    @Message(id=13, value="Duplicate subsystem declaration")
    public XMLStreamException duplicateSubsystemDeclaration(@Param Location var1);

    @Message(id=14, value="%s %s already declared")
    public XMLStreamException elementAlreadyDeclared(String var1, Object var2, @Param Location var3);

    @Message(id=15, value="Failed to parse %s")
    public DeploymentUnitProcessingException failedToParseXml(@Cause Throwable var1, VirtualFile var2);

    @Message(id=16, value="Failed to parse %s at [%d,%d]")
    public DeploymentUnitProcessingException failedToParseXml(@Cause Throwable var1, VirtualFile var2, int var3, int var4);

    @Message(id=17, value="Malformed URL provided for option %s")
    public String malformedUrl(String var1);

    @Message(id=18, value="More than one application client found and no app client name specified")
    public RuntimeException multipleAppClientsFound();

    @Message(id=19, value="Model contains multiple %s nodes")
    public IllegalStateException multipleNodesFound(String var1);

    @Message(id=20, value="Unknown option %s")
    public String unknownOption(String var1);

    @Message(id=21, value="Could not load callback-handler class %s")
    public DeploymentUnitProcessingException couldNotLoadCallbackClass(String var1);

    @Message(id=22, value="Could not create instance of callback-handler class %s")
    public DeploymentUnitProcessingException couldNotCreateCallbackHandler(String var1);

    @Message(id=23, value="Could find application client %s")
    public RuntimeException cannotFindAppClientFile(File var1);

    @Message(id=24, value="Cannot specify both a host to connect to and an ejb-client.properties file. ")
    public RuntimeException cannotSpecifyBothHostAndPropertiesFile();

    @Message(id=25, value="Unable to load ejb-client.properties URL: %s ")
    public DeploymentUnitProcessingException exceptionLoadingEjbClientPropertiesURL(String var1, @Cause Throwable var2);
}

