/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.ejb;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.marshalling.ByteWriter;
import org.jboss.marshalling.ObjectTable;
import org.jboss.marshalling.Unmarshaller;

final class ProtocolV1ObjectTable
implements ObjectTable {
    static final ProtocolV1ObjectTable INSTANCE = new ProtocolV1ObjectTable();
    private static final Map<Object, ByteWriter> writers;
    private static final Object[] objects;

    ProtocolV1ObjectTable() {
    }

    public ObjectTable.Writer getObjectWriter(Object object) throws IOException {
        return (ObjectTable.Writer)writers.get(object);
    }

    public Object readObject(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int idx = unmarshaller.readUnsignedByte();
        if (idx >= objects.length) {
            throw new InvalidObjectException("ObjectTable " + this.getClass().getName() + " cannot find an object for object index " + idx);
        }
        return objects[idx];
    }

    static {
        objects = new Object[]{"jboss.transaction.id", Affinity.NONE, "jboss.ejb.weak.affinity", "org.jboss.ejb.client.invocation.attachments", AttachmentKeys.TRANSACTION_ID_KEY, AttachmentKeys.WEAK_AFFINITY, AttachmentKeys.COMPRESS_RESPONSE, AttachmentKeys.RESPONSE_COMPRESSION_LEVEL};
        IdentityHashMap<Object, ByteWriter> map = new IdentityHashMap<Object, ByteWriter>();
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            map.put(objects[i], new ByteWriter(new byte[]{(byte)i}));
        }
        writers = map;
    }
}

