/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.infinispan.Cache;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.controller.BinaryRequirementAliasBuilder;
import org.jboss.as.clustering.controller.BinaryServiceNameFactory;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.NodeFactory;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.service.CacheBuilder;
import org.wildfly.clustering.infinispan.spi.service.TemplateConfigurationBuilder;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorBuilder;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;
import org.wildfly.clustering.web.session.SessionManagerFactoryConfiguration;

public class InfinispanSessionManagerFactoryBuilder<C extends Marshallability>
implements CapabilityServiceBuilder<SessionManagerFactory<TransactionBatch>>,
Value<SessionManagerFactory<TransactionBatch>>,
InfinispanSessionManagerFactoryConfiguration<C> {
    public static final String DEFAULT_CACHE_CONTAINER = "web";
    private final InjectedValue<Cache> cache = new InjectedValue();
    private final InjectedValue<NodeFactory> nodeFactory = new InjectedValue();
    private final SessionManagerFactoryConfiguration<C> configuration;
    private final String containerName;
    private final CapabilityServiceBuilder<?> configurationBuilder;
    private final CapabilityServiceBuilder<?> cacheBuilder;
    private final CapabilityServiceBuilder<?> nodeFactoryBuilder;
    private final CapabilityServiceBuilder<?> registryBuilder;
    private volatile ValueDependency<KeyAffinityServiceFactory> affinityFactory;
    private volatile ValueDependency<CommandDispatcherFactory> dispatcherFactory;

    public InfinispanSessionManagerFactoryBuilder(SessionManagerFactoryConfiguration<C> configuration) {
        this.configuration = configuration;
        ServiceName baseServiceName = ServiceName.JBOSS.append(new String[]{"infinispan"});
        String configCacheName = this.configuration.getCacheName();
        ServiceName configServiceName = ServiceName.parse((String)(configCacheName != null ? configCacheName : DEFAULT_CACHE_CONTAINER));
        if (!baseServiceName.isParentOf(configServiceName)) {
            configServiceName = baseServiceName.append(configServiceName);
        }
        this.containerName = (configServiceName.length() > 3 ? configServiceName.getParent() : configServiceName).getSimpleName();
        String templateCacheName = configServiceName.length() > 3 ? configServiceName.getSimpleName() : null;
        String cacheName = this.configuration.getDeploymentName();
        this.configurationBuilder = new TemplateConfigurationBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CONFIGURATION.resolve(this.containerName, cacheName)), this.containerName, cacheName, templateCacheName);
        this.cacheBuilder = new CacheBuilder(ServiceName.parse((String)InfinispanCacheRequirement.CACHE.resolve(this.containerName, cacheName)), this.containerName, cacheName);
        this.nodeFactoryBuilder = new BinaryRequirementAliasBuilder(InfinispanRouteLocatorBuilder.getNodeFactoryServiceAlias(cacheName), (BinaryServiceNameFactory)ClusteringCacheRequirement.NODE_FACTORY, this.containerName, "routing", ClusteringCacheRequirement.NODE_FACTORY.getType());
        this.registryBuilder = new BinaryRequirementAliasBuilder(InfinispanRouteLocatorBuilder.getRegistryServiceAlias(cacheName), (BinaryServiceNameFactory)ClusteringCacheRequirement.REGISTRY, this.containerName, "routing", ClusteringCacheRequirement.REGISTRY.getType());
    }

    public ServiceName getServiceName() {
        return ServiceName.JBOSS.append(new String[]{"clustering", DEFAULT_CACHE_CONTAINER, this.configuration.getDeploymentName()});
    }

    public Builder<SessionManagerFactory<TransactionBatch>> configure(CapabilityServiceSupport support) {
        this.configurationBuilder.configure(support);
        this.cacheBuilder.configure(support);
        this.nodeFactoryBuilder.configure(support);
        this.registryBuilder.configure(support);
        this.affinityFactory = new InjectedValueDependency(InfinispanRequirement.KEY_AFFINITY_FACTORY.getServiceName(support, this.containerName), KeyAffinityServiceFactory.class);
        this.dispatcherFactory = new InjectedValueDependency(ClusteringRequirement.COMMAND_DISPATCHER_FACTORY.getServiceName(support, this.containerName), CommandDispatcherFactory.class);
        return this;
    }

    public ServiceBuilder<SessionManagerFactory<TransactionBatch>> build(ServiceTarget target) {
        String cacheName = this.configuration.getDeploymentName();
        this.configurationBuilder.build(target).install();
        this.cacheBuilder.build(target).addAliases(new ServiceName[]{InfinispanRouteLocatorBuilder.getCacheServiceAlias(cacheName)}).install();
        this.nodeFactoryBuilder.build(target).install();
        this.registryBuilder.build(target).install();
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(this.cacheBuilder.getServiceName(), Cache.class, this.cache).addDependency(this.nodeFactoryBuilder.getServiceName(), NodeFactory.class, this.nodeFactory).setInitialMode(ServiceController.Mode.ON_DEMAND);
        this.affinityFactory.register(builder);
        this.dispatcherFactory.register(builder);
        return builder;
    }

    public SessionManagerFactory<TransactionBatch> getValue() {
        return new InfinispanSessionManagerFactory(this);
    }

    @Override
    public SessionManagerFactoryConfiguration<C> getSessionManagerFactoryConfiguration() {
        return this.configuration;
    }

    @Override
    public <K, V> Cache<K, V> getCache() {
        return (Cache)this.cache.getValue();
    }

    @Override
    public KeyAffinityServiceFactory getKeyAffinityServiceFactory() {
        return (KeyAffinityServiceFactory)this.affinityFactory.getValue();
    }

    @Override
    public CommandDispatcherFactory getCommandDispatcherFactory() {
        return (CommandDispatcherFactory)this.dispatcherFactory.getValue();
    }

    @Override
    public NodeFactory<Address> getNodeFactory() {
        return (NodeFactory)this.nodeFactory.getValue();
    }
}

