/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class AddressUtils {
    private static final Pattern VALID_IPV4_PATTERN;
    private static final Pattern VALID_IPV6_PATTERN;
    private static final Pattern VALID_BASIC_HOSTNAME_PATTERN;
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String ipv6Pattern = "^([\\dA-F]{1,4}:|((?=.*(::))(?!.*\\3.+\\3))\\3?)([\\dA-F]{1,4}(\\3|:\\b)|\\2){5}(([\\dA-F]{1,4}(\\3|:\\b|$)|\\2){2}|(((2[0-4]|1\\d|[1-9])?\\d|25[0-5])\\.?\\b){4})\\z";
    private static final String basicHostnamePattern = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$";

    public static boolean isValidIPv4Address(String ipAddress) {
        Matcher m = VALID_IPV4_PATTERN.matcher(ipAddress);
        return m.matches();
    }

    public static boolean isValidIPv6Address(String ipAddress) {
        Matcher m = VALID_IPV6_PATTERN.matcher(ipAddress);
        return m.matches();
    }

    public static boolean isValidHostnameAddress(String hostname) {
        Matcher m = VALID_BASIC_HOSTNAME_PATTERN.matcher(hostname);
        return m.matches() ? hostname.length() <= 255 : false;
    }

    public static boolean isValidIPAddress(String ipAddress) {
        return AddressUtils.isValidIPv4Address(ipAddress) || AddressUtils.isValidIPv6Address(ipAddress);
    }

    public static boolean isValidAddress(String address) {
        return AddressUtils.isValidIPAddress(address) || AddressUtils.isValidHostnameAddress(address);
    }

    static {
        try {
            VALID_IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
            VALID_IPV6_PATTERN = Pattern.compile(ipv6Pattern, 2);
            VALID_BASIC_HOSTNAME_PATTERN = Pattern.compile(basicHostnamePattern, 2);
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

