/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.handlers.PathHandler;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.HttpInvokerHostService;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;

public class HttpInvokerDefinition
extends PersistentResourceDefinition {
    private static final String HTTP_AUTHENTICATION_FACTORY_CAPABILITY = "org.wildfly.security.http-authentication-factory";
    protected static final SimpleAttributeDefinition HTTP_AUTHENTICATION_FACTORY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-authentication-factory", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, true))).setRestartAllServices()).build();
    protected static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1))).setDefaultValue(new ModelNode("wildfly-services"))).setRestartAllServices()).build();
    static final Collection<SimpleAttributeDefinition> ATTRIBUTES = Arrays.asList(PATH, HTTP_AUTHENTICATION_FACTORY);
    static final HttpInvokerDefinition INSTANCE = new HttpInvokerDefinition();

    private HttpInvokerDefinition() {
        super(UndertowExtension.PATH_HTTP_INVOKER, (ResourceDescriptionResolver)UndertowExtension.getResolver("http-invoker"), (OperationStepHandler)new HttpInvokerAdd(), (OperationStepHandler)new HttpInvokerRemove());
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    private static final class HttpInvokerRemove
    extends ServiceRemoveStepHandler {
        protected HttpInvokerRemove() {
            super((AbstractAddStepHandler)new HttpInvokerAdd());
        }

        protected ServiceName serviceName(String name, PathAddress address) {
            PathAddress hostAddress = address.subAddress(0, address.size() - 1);
            PathAddress serverAddress = hostAddress.subAddress(0, hostAddress.size() - 1);
            String serverName = serverAddress.getLastElement().getValue();
            String hostName = hostAddress.getLastElement().getValue();
            return UndertowService.virtualHostName(serverName, hostName).append(new String[]{"http-invoker"});
        }
    }

    private static final class HttpInvokerAdd
    extends AbstractAddStepHandler {
        public HttpInvokerAdd() {
            super(ATTRIBUTES);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            PathAddress hostAddress = address.subAddress(0, address.size() - 1);
            PathAddress serverAddress = hostAddress.subAddress(0, hostAddress.size() - 1);
            String path = PATH.resolveModelAttribute(context, model).asString();
            String httpAuthenticationFactory = null;
            ModelNode authFactory = HTTP_AUTHENTICATION_FACTORY.resolveModelAttribute(context, model);
            if (authFactory.isDefined()) {
                httpAuthenticationFactory = authFactory.asString();
            }
            HttpInvokerHostService service = new HttpInvokerHostService(path);
            String serverName = serverAddress.getLastElement().getValue();
            String hostName = hostAddress.getLastElement().getValue();
            ServiceName hostServiceName = UndertowService.virtualHostName(serverName, hostName);
            ServiceName serviceName = UndertowService.virtualHostName(serverName, hostName).append(new String[]{"http-invoker"});
            ServiceBuilder builder = context.getServiceTarget().addService(serviceName, (Service)service).addDependency(hostServiceName, Host.class, service.getHost()).addDependency(UndertowRootDefinition.HTTP_INVOKER_RUNTIME_CAPABILITY.getCapabilityServiceName(), PathHandler.class, service.getRemoteHttpInvokerServiceInjectedValue());
            if (httpAuthenticationFactory != null) {
                builder.addDependency(context.getCapabilityServiceName(RuntimeCapability.buildDynamicCapabilityName((String)HttpInvokerDefinition.HTTP_AUTHENTICATION_FACTORY_CAPABILITY, (String)httpAuthenticationFactory), HttpAuthenticationFactory.class), HttpAuthenticationFactory.class, service.getHttpAuthenticationFactoryInjectedValue());
            }
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }
}

