/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.Handlers;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.error.FileErrorPageHandler;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.undertow.filters.Filter;

public class ErrorPageDefinition
extends Filter {
    public static final AttributeDefinition CODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("code", ModelType.INT).setAllowExpression(true)).setAllowNull(false)).setRestartAllServices()).build();
    public static final AttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING).setAllowExpression(true)).setAllowNull(true)).setRestartAllServices()).build();
    public static final Collection<AttributeDefinition> ATTRIBUTES = Collections.unmodifiableCollection(Arrays.asList(CODE, PATH));
    public static final ErrorPageDefinition INSTANCE = new ErrorPageDefinition();

    private ErrorPageDefinition() {
        super("error-page");
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public Class<? extends HttpHandler> getHandlerClass() {
        return FileErrorPageHandler.class;
    }

    @Override
    public HttpHandler createHttpHandler(Predicate predicate, ModelNode model, HttpHandler next) {
        int code = model.get(CODE.getName()).asInt();
        String path = model.get(PATH.getName()).asString();
        FileErrorPageHandler handler = new FileErrorPageHandler(Paths.get(path, new String[0]), new Integer[]{code});
        handler.setNext(next);
        if (predicate == null) {
            return handler;
        }
        return Handlers.predicate((Predicate)predicate, (HttpHandler)handler, (HttpHandler)next);
    }

    @Override
    protected Class[] getConstructorSignature() {
        throw new IllegalStateException();
    }
}

