/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import java.util.Collection;
import java.util.stream.Collectors;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.cache.CacheFactoryBuilder;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderService;
import org.jboss.as.ejb3.cache.CacheInfo;
import org.jboss.as.ejb3.component.stateful.MarshallingConfigurationRepositoryValue;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.deployment.ModuleDeployment;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.clustering.service.InjectedValueDependency;

public class CacheDependenciesProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext context) {
        DeploymentUnit unit = context.getDeploymentUnit();
        final ServiceName name = unit.getServiceName();
        EEModuleDescription moduleDescription = (EEModuleDescription)unit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        final CapabilityServiceSupport support = (CapabilityServiceSupport)unit.getAttachment(org.jboss.as.server.deployment.Attachments.CAPABILITY_SERVICE_SUPPORT);
        final ServiceTarget target = context.getServiceTarget();
        final Collection cacheDependencies = moduleDescription.getComponentDescriptions().stream().filter(StatefulComponentDescription.class::isInstance).map(description -> new InjectedValueDependency(CacheDependenciesProcessor.getCacheFactoryBuilderServiceName((StatefulComponentDescription)((Object)description)), CacheFactoryBuilder.class)).distinct().collect(Collectors.toList());
        AbstractService<Void> service = new AbstractService<Void>(){

            public void start(StartContext context) {
                cacheDependencies.stream().map(Value::getValue).distinct().forEach(builder -> builder.installDeploymentUnitDependencies(support, target, name));
            }
        };
        ServiceBuilder builder = target.addService(name.append(new String[]{"cache-dependencies-installer"}), (Service)service);
        cacheDependencies.forEach(dependency -> dependency.register(builder));
        builder.install();
        InjectedValue deployment = new InjectedValue();
        Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        target.addService(MarshallingConfigurationRepositoryValue.getServiceName(name), (Service)new ValueService((Value)new MarshallingConfigurationRepositoryValue((Value<ModuleDeployment>)deployment, (Value<Module>)new ImmediateValue((Object)module)))).addDependency(name.append(ModuleDeployment.SERVICE_NAME), ModuleDeployment.class, (Injector)deployment).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static ServiceName getCacheFactoryBuilderServiceName(StatefulComponentDescription description) {
        if (!description.isPassivationApplicable()) {
            return CacheFactoryBuilderService.DEFAULT_PASSIVATION_DISABLED_CACHE_SERVICE_NAME;
        }
        CacheInfo cache = description.getCache();
        return cache != null ? CacheFactoryBuilderService.getServiceName(cache.getName()) : CacheFactoryBuilderService.DEFAULT_CACHE_SERVICE_NAME;
    }
}

